package software.amazon.awscdk.services.iam;

/**
 * Options for the `withoutPolicyUpdates()` modifier of a Role.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * WithoutPolicyUpdatesOptions withoutPolicyUpdatesOptions = WithoutPolicyUpdatesOptions.builder()
 *         .addGrantsToResources(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-26T16:25:21.418Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.WithoutPolicyUpdatesOptions")
@software.amazon.jsii.Jsii.Proxy(WithoutPolicyUpdatesOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WithoutPolicyUpdatesOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Add grants to resources instead of dropping them.
     * <p>
     * If this is <code>false</code> or not specified, grant permissions added to this role are ignored.
     * It is your own responsibility to make sure the role has the required permissions.
     * <p>
     * If this is <code>true</code>, any grant permissions will be added to the resource instead.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAddGrantsToResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WithoutPolicyUpdatesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WithoutPolicyUpdatesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WithoutPolicyUpdatesOptions> {
        java.lang.Boolean addGrantsToResources;

        /**
         * Sets the value of {@link WithoutPolicyUpdatesOptions#getAddGrantsToResources}
         * @param addGrantsToResources Add grants to resources instead of dropping them.
         *                             If this is <code>false</code> or not specified, grant permissions added to this role are ignored.
         *                             It is your own responsibility to make sure the role has the required permissions.
         *                             <p>
         *                             If this is <code>true</code>, any grant permissions will be added to the resource instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addGrantsToResources(java.lang.Boolean addGrantsToResources) {
            this.addGrantsToResources = addGrantsToResources;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WithoutPolicyUpdatesOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WithoutPolicyUpdatesOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WithoutPolicyUpdatesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WithoutPolicyUpdatesOptions {
        private final java.lang.Boolean addGrantsToResources;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addGrantsToResources = software.amazon.jsii.Kernel.get(this, "addGrantsToResources", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addGrantsToResources = builder.addGrantsToResources;
        }

        @Override
        public final java.lang.Boolean getAddGrantsToResources() {
            return this.addGrantsToResources;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddGrantsToResources() != null) {
                data.set("addGrantsToResources", om.valueToTree(this.getAddGrantsToResources()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.WithoutPolicyUpdatesOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WithoutPolicyUpdatesOptions.Jsii$Proxy that = (WithoutPolicyUpdatesOptions.Jsii$Proxy) o;

            return this.addGrantsToResources != null ? this.addGrantsToResources.equals(that.addGrantsToResources) : that.addGrantsToResources == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addGrantsToResources != null ? this.addGrantsToResources.hashCode() : 0;
            return result;
        }
    }
}
