package software.amazon.awscdk.services.iam;

/**
 * Principal entity that represents a SAML federated identity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * SamlPrincipal principal = new SamlPrincipal(provider, Map.of(
 *         "StringEquals", Map.of(
 *                 "SAML:iss", "issuer")));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:28.449Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.SamlPrincipal")
public class SamlPrincipal extends software.amazon.awscdk.services.iam.FederatedPrincipal {

    protected SamlPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SamlPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param samlProvider This parameter is required.
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SamlPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.ISamlProvider samlProvider, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(samlProvider, "samlProvider is required"), java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
