package software.amazon.awscdk.services.iam;

/**
 * The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles, or groups.
 * 
 * For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:40.366Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Policy")
public class Policy extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IPolicy {

    protected Policy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Policy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.PolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param policyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IPolicy fromPolicyName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String policyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Policy.class, "fromPolicyName", software.amazon.awscdk.services.iam.IPolicy.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(policyName, "policyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     * 
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        this.jsiiCall("addStatements", Void.class, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     * 
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final software.amazon.awscdk.services.iam.IGroup group) {
        this.jsiiCall("attachToGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     * 
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final software.amazon.awscdk.services.iam.IRole role) {
        this.jsiiCall("attachToRole", Void.class, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     * 
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final software.amazon.awscdk.services.iam.IUser user) {
        this.jsiiCall("attachToUser", Void.class, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * The name of this policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getPolicyName() {
        return this.jsiiGet("policyName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.Policy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.PolicyProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param groups Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        /**
         * @return {@code this}
         * @param policyName The name of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props().policyName(policyName);
            return this;
        }

        /**
         * @return {@code this}
         * @param roles Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.util.List<software.amazon.awscdk.services.iam.IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        /**
         * @return {@code this}
         * @param statements Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * @return {@code this}
         * @param users Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            this.props().users(users);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.Policy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.Policy build() {
            return new software.amazon.awscdk.services.iam.Policy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyProps.Builder();
            }
            return this.props;
        }
    }
}
