package software.amazon.awscdk.services.iam;

/**
 * A PolicyDocument is a collection of statements.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:40.366Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyDocument")
public class PolicyDocument extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IResolvable {

    protected PolicyDocument(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyDocument(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyDocument(final software.amazon.awscdk.services.iam.PolicyDocumentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyDocument() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Adds a statement to the policy document.
     * 
     * @param statement the statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        this.jsiiCall("addStatements", Void.class, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Produce the Token's value at resolution time.
     * 
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.Object resolve(final software.amazon.awscdk.core.IResolveContext context) {
        return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * JSON-ify the document.
     * 
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object toJSON() {
        return this.jsiiCall("toJSON", java.lang.Object.class);
    }

    /**
     * Encode the policy document as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * 
     * If this returns an empty array the stack will not be attached.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("creationStack", java.util.List.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getIsEmpty() {
        return this.jsiiGet("isEmpty", java.lang.Boolean.class);
    }

    /**
     * The number of statements already added to this policy. Can be used, for example, to generate uniuqe "sid"s within the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number getStatementCount() {
        return this.jsiiGet("statementCount", java.lang.Number.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.PolicyDocument}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props;

        private Builder() {
        }

        /**
         * @return {@code this}
         * @param assignSids Automatically assign Statement Ids to all statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignSids(final java.lang.Boolean assignSids) {
            this.props().assignSids(assignSids);
            return this;
        }

        /**
         * @return {@code this}
         * @param statements Initial statements to add to the policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.PolicyDocument}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.PolicyDocument build() {
            return new software.amazon.awscdk.services.iam.PolicyDocument(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder();
            }
            return this.props;
        }
    }
}
