package software.amazon.awscdk.services.iam;

/**
 * IAM Role.
 * 
 * Defines an IAM role. The role is created with an assume policy document associated with
 * the specified AWS service principal defined in `serviceAssumeRole`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:40.368Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Role")
public class Role extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IRole {

    protected Role(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Role(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an external role by ARN.
     * 
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     * @param options allow customizing the behavior of the returned role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IRole fromRoleArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String roleArn, final software.amazon.awscdk.services.iam.FromRoleArnOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.awscdk.services.iam.IRole.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required"), options });
    }

    /**
     * Imports an external role by ARN.
     * 
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param roleArn the ARN of the role to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IRole fromRoleArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String roleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Role.class, "fromRoleArn", software.amazon.awscdk.services.iam.IRole.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(roleArn, "roleArn is required") });
    }

    /**
     * Attaches a managed policy to this role.
     * 
     * @param policy The the managed policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        this.jsiiCall("addManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Adds a permission to the role's default policy document. If there is no default policy attached to this role, it will be created.
     * 
     * @param statement The permission statement to add to the policy document. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attaches a policy to this role.
     * 
     * @param policy The policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     * 
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grant(final software.amazon.awscdk.services.iam.IPrincipal grantee, final java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant permissions to the given principal to pass this role.
     * 
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantPassRole(final software.amazon.awscdk.services.iam.IPrincipal identity) {
        return this.jsiiCall("grantPassRole", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Returns the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * Returns the stable and unique string identifying the role.
     * 
     * For example,
     * AIDAJQABLZS4A3QDU576Q.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    /**
     * Returns the name of the role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }

    /**
     * The assume role policy document associated with this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PolicyDocument getAssumeRolePolicy() {
        return this.jsiiGet("assumeRolePolicy", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * Returns the permissions boundary attached to this role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return this.jsiiGet("permissionsBoundary", software.amazon.awscdk.services.iam.IManagedPolicy.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.Role}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.RoleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.RoleProps.Builder();
        }

        /**
         * @return {@code this}
         * @param assumedBy The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumedBy(final software.amazon.awscdk.services.iam.IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        /**
         * @return {@code this}
         * @param externalId ID that the role assumer needs to provide when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder externalId(final java.lang.String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        /**
         * @return {@code this}
         * @param externalIds List of IDs that the role assumer needs to provide one of when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIds(final java.util.List<java.lang.String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        /**
         * @return {@code this}
         * @param inlinePolicies A list of named policies to inline into this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlinePolicies(final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        /**
         * @return {@code this}
         * @param managedPolicies A list of managed policies associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        /**
         * @return {@code this}
         * @param maxSessionDuration The maximum session duration that you want to set for the specified role. This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSessionDuration(final software.amazon.awscdk.core.Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        /**
         * @return {@code this}
         * @param path The path associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * @return {@code this}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles). A permissions boundary is an advanced feature for using a managed policy to set the maximum permissions that an identity-based policy can grant to an IAM entity. An entity's permissions boundary allows it to perform only the actions that are allowed by both its identity-based policies and its permissions boundaries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * @return {@code this}
         * @param roleName A name for the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleName(final java.lang.String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.Role}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.Role build() {
            return new software.amazon.awscdk.services.iam.Role(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
