package software.amazon.awscdk.services.iam;

/**
 * Properties for a new PolicyDocument.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole myTrustedAdminRole = Role.fromRoleArn(this, "TrustedRole", "arn:aws:iam:....");
 * // Creates a limited admin policy and assigns to the account root.
 * PolicyDocument myCustomPolicy = PolicyDocument.Builder.create()
 *         .statements(List.of(PolicyStatement.Builder.create()
 *                 .actions(List.of("kms:Create*", "kms:Describe*", "kms:Enable*", "kms:List*", "kms:Put*"))
 *                 .principals(List.of(new AccountRootPrincipal()))
 *                 .resources(List.of("*"))
 *                 .build()))
 *         .build();
 * Key key = Key.Builder.create(this, "MyKey")
 *         .policy(myCustomPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-06-14T14:06:31.462Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyDocumentProps")
@software.amazon.jsii.Jsii.Proxy(PolicyDocumentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyDocumentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Automatically assign Statement Ids to all statements.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignSids() {
        return null;
    }

    /**
     * Try to minimize the policy by merging statements.
     * <p>
     * To avoid overrunning the maximum policy size, combine statements if they produce
     * the same result. Merging happens according to the following rules:
     * <p>
     * <ul>
     * <li>The Effect of both statements is the same</li>
     * <li>Neither of the statements have a 'Sid'</li>
     * <li>Combine Principals if the rest of the statement is exactly the same.</li>
     * <li>Combine Resources if the rest of the statement is exactly the same.</li>
     * <li>Combine Actions if the rest of the statement is exactly the same.</li>
     * <li>We will never combine NotPrincipals, NotResources or NotActions, because doing
     * so would change the meaning of the policy document.</li>
     * </ul>
     * <p>
     * Default: - false, unless the feature flag `@aws-cdk/aws-iam:minimizePolicies` is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMinimize() {
        return null;
    }

    /**
     * Initial statements to add to the policy document.
     * <p>
     * Default: - No statements
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyDocumentProps> {
        java.lang.Boolean assignSids;
        java.lang.Boolean minimize;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;

        /**
         * Sets the value of {@link PolicyDocumentProps#getAssignSids}
         * @param assignSids Automatically assign Statement Ids to all statements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignSids(java.lang.Boolean assignSids) {
            this.assignSids = assignSids;
            return this;
        }

        /**
         * Sets the value of {@link PolicyDocumentProps#getMinimize}
         * @param minimize Try to minimize the policy by merging statements.
         *                 To avoid overrunning the maximum policy size, combine statements if they produce
         *                 the same result. Merging happens according to the following rules:
         *                 <p>
         *                 <ul>
         *                 <li>The Effect of both statements is the same</li>
         *                 <li>Neither of the statements have a 'Sid'</li>
         *                 <li>Combine Principals if the rest of the statement is exactly the same.</li>
         *                 <li>Combine Resources if the rest of the statement is exactly the same.</li>
         *                 <li>Combine Actions if the rest of the statement is exactly the same.</li>
         *                 <li>We will never combine NotPrincipals, NotResources or NotActions, because doing
         *                 so would change the meaning of the policy document.</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimize(java.lang.Boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        /**
         * Sets the value of {@link PolicyDocumentProps#getStatements}
         * @param statements Initial statements to add to the policy document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder statements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.statements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)statements;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyDocumentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyDocumentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyDocumentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyDocumentProps {
        private final java.lang.Boolean assignSids;
        private final java.lang.Boolean minimize;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignSids = software.amazon.jsii.Kernel.get(this, "assignSids", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.minimize = software.amazon.jsii.Kernel.get(this, "minimize", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignSids = builder.assignSids;
            this.minimize = builder.minimize;
            this.statements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.statements;
        }

        @Override
        public final java.lang.Boolean getAssignSids() {
            return this.assignSids;
        }

        @Override
        public final java.lang.Boolean getMinimize() {
            return this.minimize;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.statements;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignSids() != null) {
                data.set("assignSids", om.valueToTree(this.getAssignSids()));
            }
            if (this.getMinimize() != null) {
                data.set("minimize", om.valueToTree(this.getMinimize()));
            }
            if (this.getStatements() != null) {
                data.set("statements", om.valueToTree(this.getStatements()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.PolicyDocumentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyDocumentProps.Jsii$Proxy that = (PolicyDocumentProps.Jsii$Proxy) o;

            if (this.assignSids != null ? !this.assignSids.equals(that.assignSids) : that.assignSids != null) return false;
            if (this.minimize != null ? !this.minimize.equals(that.minimize) : that.minimize != null) return false;
            return this.statements != null ? this.statements.equals(that.statements) : that.statements == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assignSids != null ? this.assignSids.hashCode() : 0;
            result = 31 * result + (this.minimize != null ? this.minimize.hashCode() : 0);
            result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
            return result;
        }
    }
}
