package software.amazon.awscdk.services.iam;

/**
 * IAM OIDC identity providers are entities in IAM that describe an external identity provider (IdP) service that supports the OpenID Connect (OIDC) standard, such as Google or Salesforce.
 * <p>
 * You use an IAM OIDC identity provider
 * when you want to establish trust between an OIDC-compatible IdP and your AWS
 * account. This is useful when creating a mobile app or web application that
 * requires access to AWS resources, but you don't want to create custom sign-in
 * code or manage your own user identities.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenIdConnectProvider provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clientIds(List.of("myclient1", "myclient2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:20.698Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.OpenIdConnectProvider")
public class OpenIdConnectProvider extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IOpenIdConnectProvider {

    protected OpenIdConnectProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OpenIdConnectProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Defines an OpenID Connect provider.
     * <p>
     * @param scope The definition scope. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param props Initialization properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenIdConnectProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.OpenIdConnectProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an Open ID connect provider from an ARN.
     * <p>
     * @param scope The definition scope. This parameter is required.
     * @param id ID of the construct. This parameter is required.
     * @param openIdConnectProviderArn the ARN to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider fromOpenIdConnectProviderArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String openIdConnectProviderArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.OpenIdConnectProvider.class, "fromOpenIdConnectProviderArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(openIdConnectProviderArn, "openIdConnectProviderArn is required") });
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM OpenID Connect provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOpenIdConnectProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The issuer for OIDC Provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOpenIdConnectProviderIssuer() {
        return software.amazon.jsii.Kernel.get(this, "openIdConnectProviderIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.OpenIdConnectProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.OpenIdConnectProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The definition scope. This parameter is required.
         * @param id Construct ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.OpenIdConnectProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.OpenIdConnectProviderProps.Builder();
        }

        /**
         * The URL of the identity provider.
         * <p>
         * The URL must begin with https:// and
         * should correspond to the iss claim in the provider's OpenID Connect ID
         * tokens. Per the OIDC standard, path components are allowed but query
         * parameters are not. Typically the URL consists of only a hostname, like
         * https://server.example.org or https://example.com.
         * <p>
         * You cannot register the same provider multiple times in a single AWS
         * account. If you try to submit a URL that has already been used for an
         * OpenID Connect provider in the AWS account, you will get an error.
         * <p>
         * @return {@code this}
         * @param url The URL of the identity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * A list of client IDs (also known as audiences).
         * <p>
         * When a mobile or web app
         * registers with an OpenID Connect provider, they establish a value that
         * identifies the application. (This is the value that's sent as the client_id
         * parameter on OAuth requests.)
         * <p>
         * You can register multiple client IDs with the same provider. For example,
         * you might have multiple applications that use the same OIDC provider. You
         * cannot register more than 100 client IDs with a single IAM OIDC provider.
         * <p>
         * Client IDs are up to 255 characters long.
         * <p>
         * Default: - no clients are allowed
         * <p>
         * @return {@code this}
         * @param clientIds A list of client IDs (also known as audiences). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientIds(final java.util.List<java.lang.String> clientIds) {
            this.props.clientIds(clientIds);
            return this;
        }

        /**
         * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
         * <p>
         * Typically this list includes only one entry. However, IAM lets you have up
         * to five thumbprints for an OIDC provider. This lets you maintain multiple
         * thumbprints if the identity provider is rotating certificates.
         * <p>
         * The server certificate thumbprint is the hex-encoded SHA-1 hash value of
         * the X.509 certificate used by the domain where the OpenID Connect provider
         * makes its keys available. It is always a 40-character string.
         * <p>
         * You must provide at least one thumbprint when creating an IAM OIDC
         * provider. For example, assume that the OIDC provider is server.example.com
         * and the provider stores its keys at
         * https://keys.server.example.com/openid-connect. In that case, the
         * thumbprint string would be the hex-encoded SHA-1 hash value of the
         * certificate used by https://keys.server.example.com.
         * <p>
         * Default: - If no thumbprints are specified (an empty array or `undefined`),
         * the thumbprint of the root certificate authority will be obtained from the
         * provider's server as described in https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
         * <p>
         * @return {@code this}
         * @param thumbprints A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thumbprints(final java.util.List<java.lang.String> thumbprints) {
            this.props.thumbprints(thumbprints);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.OpenIdConnectProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.OpenIdConnectProvider build() {
            return new software.amazon.awscdk.services.iam.OpenIdConnectProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
