package software.amazon.awscdk.services.iam;

/**
 * Managed policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role myRole = Role.Builder.create(this, "My Role")
 *         .assumedBy(new ServicePrincipal("sns.amazonaws.com"))
 *         .build();
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .role(myRole)
 *         .build();
 * myRole.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole"));
 * myRole.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaVPCAccessExecutionRole"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:25.861Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ManagedPolicy")
public class ManagedPolicy extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IManagedPolicy {

    protected ManagedPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.ManagedPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a managed policy from one of the policies that AWS manages.
     * <p>
     * For this managed policy, you only need to know the name to be able to use it.
     * <p>
     * Some managed policy names start with "service-role/", some start with
     * "job-function/", and some don't start with anything. Include the
     * prefix when constructing this object.
     * <p>
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy fromAwsManagedPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromAwsManagedPolicyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class), new Object[] { java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Import an external managed policy by ARN.
     * <p>
     * For this managed policy, you only need to know the ARN to be able to use it.
     * This can be useful if you got the ARN from a CloudFormation Export.
     * <p>
     * If the imported Managed Policy ARN is a Token (such as a
     * <code>CfnParameter.valueAsString</code> or a <code>Fn.importValue()</code>) <em>and</em> the referenced
     * managed policy has a <code>path</code> (like <code>arn:...:policy/AdminPolicy/AdminAllow</code>), the
     * <code>managedPolicyName</code> property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Managed Policy ARN should be supplied without the
     * <code>path</code> in order to resolve the correct managed policy resource.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param managedPolicyArn the ARN of the managed policy to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy fromManagedPolicyArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String managedPolicyArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromManagedPolicyArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(managedPolicyArn, "managedPolicyArn is required") });
    }

    /**
     * Import a customer managed policy from the managedPolicyName.
     * <p>
     * For this managed policy, you only need to know the name to be able to use it.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy fromManagedPolicyName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromManagedPolicyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        software.amazon.jsii.Kernel.call(this, "addStatements", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
        software.amazon.jsii.Kernel.call(this, "attachToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     * <p>
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "attachToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     * <p>
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user) {
        software.amazon.jsii.Kernel.call(this, "attachToUser", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The description of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * Returns the ARN of this managed policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getManagedPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "managedPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getManagedPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "managedPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.ManagedPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.ManagedPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the managed policy.
         * <p>
         * Typically used to store information about the
         * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         * The policy description is immutable. After a value is assigned, it cannot be changed.
         * <p>
         * Default: - empty
         * <p>
         * @return {@code this}
         * @param description A description of the managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Initial PolicyDocument to use for this ManagedPolicy.
         * <p>
         * If omited, any
         * <code>PolicyStatement</code> provided in the <code>statements</code> property will be applied
         * against the empty default <code>PolicyDocument</code>.
         * <p>
         * Default: - An empty policy.
         * <p>
         * @return {@code this}
         * @param document Initial PolicyDocument to use for this ManagedPolicy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(final software.amazon.awscdk.services.iam.PolicyDocument document) {
            this.props().document(document);
            return this;
        }

        /**
         * Groups to attach this policy to.
         * <p>
         * You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
         * <p>
         * Default: - No groups.
         * <p>
         * @return {@code this}
         * @param groups Groups to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<? extends software.amazon.awscdk.services.iam.IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        /**
         * The name of the managed policy.
         * <p>
         * If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param managedPolicyName The name of the managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(final java.lang.String managedPolicyName) {
            this.props().managedPolicyName(managedPolicyName);
            return this;
        }

        /**
         * The path for the policy.
         * <p>
         * This parameter allows (through its regex pattern) a string of characters
         * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
         * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
         * including most punctuation characters, digits, and upper and lowercased letters.
         * <p>
         * For more information about paths, see IAM Identifiers in the IAM User Guide.
         * <p>
         * Default: - "/"
         * <p>
         * @return {@code this}
         * @param path The path for the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * Roles to attach this policy to.
         * <p>
         * You can also use <code>attachToRole(role)</code> to attach this policy to a role.
         * <p>
         * Default: - No roles.
         * <p>
         * @return {@code this}
         * @param roles Roles to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.util.List<? extends software.amazon.awscdk.services.iam.IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        /**
         * Initial set of permissions to add to this policy document.
         * <p>
         * You can also use <code>addPermission(statement)</code> to add permissions later.
         * <p>
         * Default: - No statements.
         * <p>
         * @return {@code this}
         * @param statements Initial set of permissions to add to this policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * Users to attach this policy to.
         * <p>
         * You can also use <code>attachToUser(user)</code> to attach this policy to a user.
         * <p>
         * Default: - No users.
         * <p>
         * @return {@code this}
         * @param users Users to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<? extends software.amazon.awscdk.services.iam.IUser> users) {
            this.props().users(users);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.ManagedPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.ManagedPolicy build() {
            return new software.amazon.awscdk.services.iam.ManagedPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
