package software.amazon.awscdk.services.iam;

/**
 * An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:01.535Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ServicePrincipal")
public class ServicePrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected ServicePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServicePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param service This parameter is required.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final java.lang.String service, final software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final java.lang.String service) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getService() {
        return this.jsiiGet("service", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param service This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String service) {
            return new Builder(service);
        }

        private final java.lang.String service;
        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts;

        private Builder(final java.lang.String service) {
            this.service = service;
        }

        /**
         * @return {@code this}
         * @param conditions Additional conditions to add to the Service Principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.Map<java.lang.String, java.lang.Object> conditions) {
            this.opts().conditions(conditions);
            return this;
        }

        /**
         * @return {@code this}
         * @param region The region in which the service is operating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.opts().region(region);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.ServicePrincipal build() {
            return new software.amazon.awscdk.services.iam.ServicePrincipal(
                this.service,
                this.opts != null ? this.opts.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts() {
            if (this.opts == null) {
                this.opts = new software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder();
            }
            return this.opts;
        }
    }
}
