package software.amazon.awscdk.services.iam;

/**
 * A construct that represents an IAM principal, such as a user, group or role.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.7 (build e0b2c0d)", date = "2019-11-19T21:07:09.266Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.IIdentity")
@software.amazon.jsii.Jsii.Proxy(IIdentity.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IIdentity extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IPrincipal, software.amazon.awscdk.core.IResource {

    /**
     * Attaches a managed policy to this principal.
     * 
     * @param policy The managed policy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy);

    /**
     * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
     * 
     * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface]. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IIdentity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Attaches a managed policy to this principal.
         * 
         * @param policy The managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy) {
            this.jsiiCall("addManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Attaches an inline policy to this principal. This is the same as calling `policy.addToXxx(principal)`.
         * 
         * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add to the policy of this principal.
         * 
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
