package software.amazon.awscdk.services.iam;

/**
 * Principal entity that represents a SAML federated identity provider for programmatic and AWS Management Console access.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * Role.Builder.create(this, "Role")
 *         .assumedBy(new SamlConsolePrincipal(provider))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.65.1 (build b0947e4)", date = "2022-08-30T21:28:27.873Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.SamlConsolePrincipal")
public class SamlConsolePrincipal extends software.amazon.awscdk.services.iam.SamlPrincipal {

    protected SamlConsolePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SamlConsolePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param samlProvider This parameter is required.
     * @param conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SamlConsolePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.ISamlProvider samlProvider, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(samlProvider, "samlProvider is required"), conditions });
    }

    /**
     * @param samlProvider This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SamlConsolePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.ISamlProvider samlProvider) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(samlProvider, "samlProvider is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
