package software.amazon.awscdk.services.iam;

/**
 * Represents a statement in an IAM policy document.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:24.414Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement extends software.amazon.jsii.JsiiObject {

    protected PolicyStatement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyStatementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new PolicyStatement based on the object provided.
     * <p>
     * This will accept an object created from the <code>.toJSON()</code> call
     * <p>
     * @param obj the PolicyStatement in object form. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement fromJson(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.PolicyStatement.class, "fromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class), new Object[] { obj });
    }

    /**
     * Add a condition that limits to a given account.
     * <p>
     * This method can only be called once: subsequent calls will overwrite earlier calls.
     * <p>
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountCondition(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        software.amazon.jsii.Kernel.call(this, "addAccountCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * Adds an AWS account root user principal to this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountRootPrincipal() {
        software.amazon.jsii.Kernel.call(this, "addAccountRootPrincipal", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Specify allowed actions into the "Action" section of the policy statement.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html</a>
     * @param actions actions that will be allowed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addActions(final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        software.amazon.jsii.Kernel.call(this, "addActions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Adds a ``"*"`` resource to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAllResources() {
        software.amazon.jsii.Kernel.call(this, "addAllResources", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Adds all identities in all accounts ("*") to this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAnyPrincipal() {
        software.amazon.jsii.Kernel.call(this, "addAnyPrincipal", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Specify a principal using the ARN  identifier of the principal.
     * <p>
     * You cannot specify IAM groups and instance profiles as principals.
     * <p>
     * @param arn ARN identifier of AWS account, IAM user, or IAM role (i.e. arn:aws:iam::123456789012:user/user-name). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addArnPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        software.amazon.jsii.Kernel.call(this, "addArnPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Specify AWS account ID as the principal entity to the "Principal" section of a policy statement.
     * <p>
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAwsAccountPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        software.amazon.jsii.Kernel.call(this, "addAwsAccountPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * Adds a canonical user ID principal to this policy document.
     * <p>
     * @param canonicalUserId unique identifier assigned by AWS for every account. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCanonicalUserPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String canonicalUserId) {
        software.amazon.jsii.Kernel.call(this, "addCanonicalUserPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(canonicalUserId, "canonicalUserId is required") });
    }

    /**
     * Add a condition to the Policy.
     * <p>
     * If multiple calls are made to add a condition with the same operator and field, only
     * the last one wins. For example:
     * <p>
     * <blockquote><pre>
     * PolicyStatement stmt;
     * stmt.addCondition("StringEquals", Map.of("aws:SomeField", "1"));
     * stmt.addCondition("StringEquals", Map.of("aws:SomeField", "2"));
     * </pre></blockquote>
     * <p>
     * Will end up with the single condition <code>StringEquals: { 'aws:SomeField': '2' }</code>.
     * <p>
     * If you meant to add a condition to say that the field can be <em>either</em> <code>1</code> or <code>2</code>, write
     * this:
     * <p>
     * <blockquote><pre>
     * PolicyStatement stmt;
     * stmt.addCondition("StringEquals", Map.of("aws:SomeField", List.of("1", "2")));
     * </pre></blockquote>
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Add multiple conditions to the Policy.
     * <p>
     * See the <code>addCondition</code> function for a caveat on calling this method multiple times.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConditions(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        software.amazon.jsii.Kernel.call(this, "addConditions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Adds a federated identity provider such as Amazon Cognito to this policy statement.
     * <p>
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com'). This parameter is required.
     * @param conditions The conditions under which the policy is in effect. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFederatedPrincipal(final @org.jetbrains.annotations.NotNull java.lang.Object federated, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        software.amazon.jsii.Kernel.call(this, "addFederatedPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { federated, java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Explicitly allow all actions except the specified list of actions into the "NotAction" section of the policy document.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html</a>
     * @param notActions actions that will be denied. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotActions(final @org.jetbrains.annotations.NotNull java.lang.String... notActions) {
        software.amazon.jsii.Kernel.call(this, "addNotActions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(notActions).toArray(Object[]::new));
    }

    /**
     * Specify principals that is not allowed or denied access to the "NotPrincipal" section of a policy statement.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html</a>
     * @param notPrincipals IAM principals that will be denied access. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotPrincipals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal... notPrincipals) {
        software.amazon.jsii.Kernel.call(this, "addNotPrincipals", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(notPrincipals).toArray(Object[]::new));
    }

    /**
     * Specify resources that this policy statement will not apply to in the "NotResource" section of this policy statement.
     * <p>
     * All resources except the specified list will be matched.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html</a>
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement does not apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotResources(final @org.jetbrains.annotations.NotNull java.lang.String... arns) {
        software.amazon.jsii.Kernel.call(this, "addNotResources", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds principals to the "Principal" section of a policy statement.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html</a>
     * @param principals IAM principals that will be added. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPrincipals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal... principals) {
        software.amazon.jsii.Kernel.call(this, "addPrincipals", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(principals).toArray(Object[]::new));
    }

    /**
     * Specify resources that this policy statement applies into the "Resource" section of this policy statement.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_resource.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_resource.html</a>
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement applies to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResources(final @org.jetbrains.annotations.NotNull java.lang.String... arns) {
        software.amazon.jsii.Kernel.call(this, "addResources", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds a service principal to this policy statement.
     * <p>
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     * @param opts options for adding the service principal (such as specifying a principal in a different region).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        software.amazon.jsii.Kernel.call(this, "addServicePrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * Adds a service principal to this policy statement.
     * <p>
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        software.amazon.jsii.Kernel.call(this, "addServicePrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Create a new `PolicyStatement` with the same exact properties as this one, except for the overrides.
     * <p>
     * @param overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement copy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyStatementProps overrides) {
        return software.amazon.jsii.Kernel.call(this, "copy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class), new Object[] { overrides });
    }

    /**
     * Create a new `PolicyStatement` with the same exact properties as this one, except for the overrides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement copy() {
        return software.amazon.jsii.Kernel.call(this, "copy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class));
    }

    /**
     * JSON-ify the statement.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * JSON-ify the policy statement.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toStatementJson() {
        return software.amazon.jsii.Kernel.call(this, "toStatementJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * String representation of this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Validate that the policy statement satisfies base requirements for a policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the statement is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForAnyPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForAnyPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Validate that the policy statement satisfies all requirements for an identity-based policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the statement is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForIdentityPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForIdentityPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Validate that the policy statement satisfies all requirements for a resource-based policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the statement is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForResourcePolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForResourcePolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Actions added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The conditions added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConditions() {
        return software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates if this permission has a "Principal" section.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "hasPrincipal", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this permission has at least one resource associated with it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasResource() {
        return software.amazon.jsii.Kernel.get(this, "hasResource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The NotActions added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getNotActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "notActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The NotPrincipals added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getNotPrincipals() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "notPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class))));
    }

    /**
     * The NotResources added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getNotResources() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "notResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Principals added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class))));
    }

    /**
     * The Resources added to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResources() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Whether to allow or deny the actions in this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Effect getEffect() {
        return software.amazon.jsii.Kernel.get(this, "effect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Effect.class));
    }

    /**
     * Whether to allow or deny the actions in this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEffect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Effect value) {
        software.amazon.jsii.Kernel.set(this, "effect", java.util.Objects.requireNonNull(value, "effect is required"));
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSid() {
        return software.amazon.jsii.Kernel.get(this, "sid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSid(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sid", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.PolicyStatement}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.PolicyStatement> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.iam.PolicyStatementProps.Builder props;

        private Builder() {
        }

        /**
         * List of actions to add to the statement.
         * <p>
         * Default: - no actions
         * <p>
         * @return {@code this}
         * @param actions List of actions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<java.lang.String> actions) {
            this.props().actions(actions);
            return this;
        }

        /**
         * Conditions to add to the statement.
         * <p>
         * Default: - no condition
         * <p>
         * @return {@code this}
         * @param conditions Conditions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.Map<java.lang.String, ? extends java.lang.Object> conditions) {
            this.props().conditions(conditions);
            return this;
        }

        /**
         * Whether to allow or deny the actions in this statement.
         * <p>
         * Default: Effect.ALLOW
         * <p>
         * @return {@code this}
         * @param effect Whether to allow or deny the actions in this statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder effect(final software.amazon.awscdk.services.iam.Effect effect) {
            this.props().effect(effect);
            return this;
        }

        /**
         * List of not actions to add to the statement.
         * <p>
         * Default: - no not-actions
         * <p>
         * @return {@code this}
         * @param notActions List of not actions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notActions(final java.util.List<java.lang.String> notActions) {
            this.props().notActions(notActions);
            return this;
        }

        /**
         * List of not principals to add to the statement.
         * <p>
         * Default: - no not principals
         * <p>
         * @return {@code this}
         * @param notPrincipals List of not principals to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notPrincipals(final java.util.List<? extends software.amazon.awscdk.services.iam.IPrincipal> notPrincipals) {
            this.props().notPrincipals(notPrincipals);
            return this;
        }

        /**
         * NotResource ARNs to add to the statement.
         * <p>
         * Default: - no not-resources
         * <p>
         * @return {@code this}
         * @param notResources NotResource ARNs to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notResources(final java.util.List<java.lang.String> notResources) {
            this.props().notResources(notResources);
            return this;
        }

        /**
         * List of principals to add to the statement.
         * <p>
         * Default: - no principals
         * <p>
         * @return {@code this}
         * @param principals List of principals to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principals(final java.util.List<? extends software.amazon.awscdk.services.iam.IPrincipal> principals) {
            this.props().principals(principals);
            return this;
        }

        /**
         * Resource ARNs to add to the statement.
         * <p>
         * Default: - no resources
         * <p>
         * @return {@code this}
         * @param resources Resource ARNs to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<java.lang.String> resources) {
            this.props().resources(resources);
            return this;
        }

        /**
         * The Sid (statement ID) is an optional identifier that you provide for the policy statement.
         * <p>
         * You can assign a Sid value to each statement in a
         * statement array. In services that let you specify an ID element, such as
         * SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
         * IAM, the Sid value must be unique within a JSON policy.
         * <p>
         * Default: - no sid
         * <p>
         * @return {@code this}
         * @param sid The Sid (statement ID) is an optional identifier that you provide for the policy statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sid(final java.lang.String sid) {
            this.props().sid(sid);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.PolicyStatement}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.PolicyStatement build() {
            return new software.amazon.awscdk.services.iam.PolicyStatement(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyStatementProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyStatementProps.Builder();
            }
            return this.props;
        }
    }
}
