package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM user.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * User user = User.Builder.create(this, "MyUser").password(SecretValue.unsafePlainText("1234")).build();
 * Group group = new Group(this, "MyGroup");
 * Policy policy = new Policy(this, "MyPolicy");
 * policy.attachToUser(user);
 * group.attachInlinePolicy(policy);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T02:14:04.731Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.UserProps")
@software.amazon.jsii.Jsii.Proxy(UserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Groups to add this user to.
     * <p>
     * You can also use <code>addToGroup</code> to add this
     * user to a group.
     * <p>
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
        return null;
    }

    /**
     * A list of managed policies associated with this role.
     * <p>
     * You can add managed policies later using
     * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
     * <p>
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
        return null;
    }

    /**
     * The password for the user. This is required so the user can access the AWS Management Console.
     * <p>
     * You can use <code>SecretValue.unsafePlainText</code> to specify a password in plain text or
     * use <code>secretsmanager.Secret.fromSecretAttributes</code> to reference a secret in
     * Secrets Manager.
     * <p>
     * Default: - User won't be able to access the management console without a password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getPassword() {
        return null;
    }

    /**
     * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
     * <p>
     * If this is set to 'true', you must also specify "initialPassword".
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPasswordResetRequired() {
        return null;
    }

    /**
     * The path for the user name.
     * <p>
     * For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * AWS supports permissions boundaries for IAM entities (users or roles).
     * <p>
     * A permissions boundary is an advanced feature for using a managed policy
     * to set the maximum permissions that an identity-based policy can grant to
     * an IAM entity. An entity's permissions boundary allows it to perform only
     * the actions that are allowed by both its identity-based policies and its
     * permissions boundaries.
     * <p>
     * Default: - No permissions boundary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return null;
    }

    /**
     * A name for the IAM user.
     * <p>
     * For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     * <p>
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     * <p>
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * <p>
     * Default: - Generated by CloudFormation (recommended)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserProps> {
        java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        software.amazon.awscdk.core.SecretValue password;
        java.lang.Boolean passwordResetRequired;
        java.lang.String path;
        software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary;
        java.lang.String userName;

        /**
         * Sets the value of {@link UserProps#getGroups}
         * @param groups Groups to add this user to.
         *               You can also use <code>addToGroup</code> to add this
         *               user to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder groups(java.util.List<? extends software.amazon.awscdk.services.iam.IGroup> groups) {
            this.groups = (java.util.List<software.amazon.awscdk.services.iam.IGroup>)groups;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getManagedPolicies}
         * @param managedPolicies A list of managed policies associated with this role.
         *                        You can add managed policies later using
         *                        <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder managedPolicies(java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)managedPolicies;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getPassword}
         * @param password The password for the user. This is required so the user can access the AWS Management Console.
         *                 You can use <code>SecretValue.unsafePlainText</code> to specify a password in plain text or
         *                 use <code>secretsmanager.Secret.fromSecretAttributes</code> to reference a secret in
         *                 Secrets Manager.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(software.amazon.awscdk.core.SecretValue password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getPasswordResetRequired}
         * @param passwordResetRequired Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         *                              If this is set to 'true', you must also specify "initialPassword".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwordResetRequired(java.lang.Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getPath}
         * @param path The path for the user name.
         *             For more information about paths, see IAM
         *             Identifiers in the IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getPermissionsBoundary}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles).
         *                            A permissions boundary is an advanced feature for using a managed policy
         *                            to set the maximum permissions that an identity-based policy can grant to
         *                            an IAM entity. An entity's permissions boundary allows it to perform only
         *                            the actions that are allowed by both its identity-based policies and its
         *                            permissions boundaries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getUserName}
         * @param userName A name for the IAM user.
         *                 For valid values, see the UserName parameter for
         *                 the CreateUser action in the IAM API Reference. If you don't specify a
         *                 name, AWS CloudFormation generates a unique physical ID and uses that ID
         *                 for the user name.
         *                 <p>
         *                 If you specify a name, you cannot perform updates that require
         *                 replacement of this resource. You can perform updates that require no or
         *                 some interruption. If you must replace the resource, specify a new name.
         *                 <p>
         *                 If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         *                 acknowledge your template's capabilities. For more information, see
         *                 Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserProps {
        private final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private final software.amazon.awscdk.core.SecretValue password;
        private final java.lang.Boolean passwordResetRequired;
        private final java.lang.String path;
        private final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary;
        private final java.lang.String userName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGroup.class)));
            this.managedPolicies = software.amazon.jsii.Kernel.get(this, "managedPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class)));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.passwordResetRequired = software.amazon.jsii.Kernel.get(this, "passwordResetRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissionsBoundary = software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class));
            this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groups = (java.util.List<software.amazon.awscdk.services.iam.IGroup>)builder.groups;
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)builder.managedPolicies;
            this.password = builder.password;
            this.passwordResetRequired = builder.passwordResetRequired;
            this.path = builder.path;
            this.permissionsBoundary = builder.permissionsBoundary;
            this.userName = builder.userName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.groups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.managedPolicies;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Boolean getPasswordResetRequired() {
            return this.passwordResetRequired;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGroups() != null) {
                data.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getManagedPolicies() != null) {
                data.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getPasswordResetRequired() != null) {
                data.set("passwordResetRequired", om.valueToTree(this.getPasswordResetRequired()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPermissionsBoundary() != null) {
                data.set("permissionsBoundary", om.valueToTree(this.getPermissionsBoundary()));
            }
            if (this.getUserName() != null) {
                data.set("userName", om.valueToTree(this.getUserName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.UserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserProps.Jsii$Proxy that = (UserProps.Jsii$Proxy) o;

            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.managedPolicies != null ? !this.managedPolicies.equals(that.managedPolicies) : that.managedPolicies != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.passwordResetRequired != null ? !this.passwordResetRequired.equals(that.passwordResetRequired) : that.passwordResetRequired != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.permissionsBoundary != null ? !this.permissionsBoundary.equals(that.permissionsBoundary) : that.permissionsBoundary != null) return false;
            return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groups != null ? this.groups.hashCode() : 0;
            result = 31 * result + (this.managedPolicies != null ? this.managedPolicies.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.passwordResetRequired != null ? this.passwordResetRequired.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundary != null ? this.permissionsBoundary.hashCode() : 0);
            result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
            return result;
        }
    }
}
