package software.amazon.awscdk.services.iam;

/**
 * The Effect element of an IAM policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource books;
 * User iamUser;
 * Method getBooks = books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizationType(AuthorizationType.IAM)
 *         .build());
 * iamUser.attachInlinePolicy(Policy.Builder.create(this, "AllowBooks")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(getBooks.getMethodArn()))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:35.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.Effect")
public enum Effect {
    /**
     * Allows access to a resource in an IAM policy statement.
     * <p>
     * By default, access to resources are denied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOW,
    /**
     * Explicitly deny access to a resource.
     * <p>
     * By default, all requests are denied implicitly.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DENY,
}
