package software.amazon.awscdk.services.iam;

/**
 * Properties for defining a `CfnServiceLinkedRole`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnServiceLinkedRole slr = CfnServiceLinkedRole.Builder.create(this, "ElasticSLR")
 *         .awsServiceName("es.amazonaws.com")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-03T16:22:27.842Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnServiceLinkedRoleProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceLinkedRoleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceLinkedRoleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service principal for the AWS service to which this role is attached.
     * <p>
     * You use a string similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code> .
     * <p>
     * Service principals are unique and case-sensitive. To find the exact service principal for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">AWS services that work with IAM</a> in the <em>IAM User Guide</em> . Look for the services that have <em>Yes</em> in the <em>Service-Linked Role</em> column. Choose the <em>Yes</em> link to view the service-linked role documentation for that service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsServiceName();

    /**
     * A string that you provide, which is combined with the service-provided prefix to form the complete role name.
     * <p>
     * If you make multiple requests for the same service, then you must supply a different <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error. For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.
     * <p>
     * Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix and the operation fails, try the operation again without the suffix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomSuffix() {
        return null;
    }

    /**
     * The description of the role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServiceLinkedRoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceLinkedRoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceLinkedRoleProps> {
        java.lang.String awsServiceName;
        java.lang.String customSuffix;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnServiceLinkedRoleProps#getAwsServiceName}
         * @param awsServiceName The service principal for the AWS service to which this role is attached. This parameter is required.
         *                       You use a string similar to a URL but without the http:// in front. For example: <code>elasticbeanstalk.amazonaws.com</code> .
         *                       <p>
         *                       Service principals are unique and case-sensitive. To find the exact service principal for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">AWS services that work with IAM</a> in the <em>IAM User Guide</em> . Look for the services that have <em>Yes</em> in the <em>Service-Linked Role</em> column. Choose the <em>Yes</em> link to view the service-linked role documentation for that service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsServiceName(java.lang.String awsServiceName) {
            this.awsServiceName = awsServiceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLinkedRoleProps#getCustomSuffix}
         * @param customSuffix A string that you provide, which is combined with the service-provided prefix to form the complete role name.
         *                     If you make multiple requests for the same service, then you must supply a different <code>CustomSuffix</code> for each request. Otherwise the request fails with a duplicate role name error. For example, you could add <code>-1</code> or <code>-debug</code> to the suffix.
         *                     <p>
         *                     Some services do not support the <code>CustomSuffix</code> parameter. If you provide an optional suffix and the operation fails, try the operation again without the suffix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSuffix(java.lang.String customSuffix) {
            this.customSuffix = customSuffix;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLinkedRoleProps#getDescription}
         * @param description The description of the role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceLinkedRoleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceLinkedRoleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceLinkedRoleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceLinkedRoleProps {
        private final java.lang.String awsServiceName;
        private final java.lang.String customSuffix;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsServiceName = software.amazon.jsii.Kernel.get(this, "awsServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customSuffix = software.amazon.jsii.Kernel.get(this, "customSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsServiceName = java.util.Objects.requireNonNull(builder.awsServiceName, "awsServiceName is required");
            this.customSuffix = builder.customSuffix;
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getAwsServiceName() {
            return this.awsServiceName;
        }

        @Override
        public final java.lang.String getCustomSuffix() {
            return this.customSuffix;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsServiceName", om.valueToTree(this.getAwsServiceName()));
            if (this.getCustomSuffix() != null) {
                data.set("customSuffix", om.valueToTree(this.getCustomSuffix()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.CfnServiceLinkedRoleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceLinkedRoleProps.Jsii$Proxy that = (CfnServiceLinkedRoleProps.Jsii$Proxy) o;

            if (!awsServiceName.equals(that.awsServiceName)) return false;
            if (this.customSuffix != null ? !this.customSuffix.equals(that.customSuffix) : that.customSuffix != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsServiceName.hashCode();
            result = 31 * result + (this.customSuffix != null ? this.customSuffix.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
