package software.amazon.awscdk.services.iam;

/**
 * An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role lambdaRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .description("Example role...")
 *         .build();
 * Stream stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .build();
 * // give lambda permissions to read stream
 * stream.grantRead(lambdaRole);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-03T16:22:27.920Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ServicePrincipal")
public class ServicePrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected ServicePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServicePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Translate the given service principal name based on the region it's used in.
     * <p>
     * For example, for Chinese regions this may (depending on whether that's necessary
     * for the given service principal) append <code>.cn</code> to the name.
     * <p>
     * The <code>region-info</code> module is used to obtain this information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * String principalName = ServicePrincipal.servicePrincipalName("ec2.amazonaws.com");
     * </pre></blockquote>
     * <p>
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String servicePrincipalName(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ServicePrincipal.class, "servicePrincipalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Return whether or not this principal is equal to the given principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable java.lang.String dedupeString() {
        return software.amazon.jsii.Kernel.call(this, "dedupeString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * AWS service (i.e. sqs.amazonaws.com).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.ServicePrincipal> {
        /**
         * @return a new instance of {@link Builder}.
         * @param service AWS service (i.e. sqs.amazonaws.com). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String service) {
            return new Builder(service);
        }

        private final java.lang.String service;
        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts;

        private Builder(final java.lang.String service) {
            this.service = service;
        }

        /**
         * Additional conditions to add to the Service Principal.
         * <p>
         * Default: - No conditions
         * <p>
         * @return {@code this}
         * @param conditions Additional conditions to add to the Service Principal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.Map<java.lang.String, ? extends java.lang.Object> conditions) {
            this.opts().conditions(conditions);
            return this;
        }

        /**
         * (deprecated) The region in which the service is operating.
         * <p>
         * Default: - the current Stack's region.
         * <p>
         * @return {@code this}
         * @deprecated You should not need to set this. The stack's region is always correct.
         * @param region The region in which the service is operating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder region(final java.lang.String region) {
            this.opts().region(region);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.ServicePrincipal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.ServicePrincipal build() {
            return new software.amazon.awscdk.services.iam.ServicePrincipal(
                this.service,
                this.opts != null ? this.opts.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder opts() {
            if (this.opts == null) {
                this.opts = new software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder();
            }
            return this.opts;
        }
    }
}
