package software.amazon.awscdk.services.iam;

/**
 * A PolicyDocument is a collection of statements.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole myTrustedAdminRole = Role.fromRoleArn(this, "TrustedRole", "arn:aws:iam:....");
 * // Creates a limited admin policy and assigns to the account root.
 * PolicyDocument myCustomPolicy = PolicyDocument.Builder.create()
 *         .statements(List.of(PolicyStatement.Builder.create()
 *                 .actions(List.of("kms:Create*", "kms:Describe*", "kms:Enable*", "kms:List*", "kms:Put*"))
 *                 .principals(List.of(new AccountRootPrincipal()))
 *                 .resources(List.of("*"))
 *                 .build()))
 *         .build();
 * Key key = Key.Builder.create(this, "MyKey")
 *         .policy(myCustomPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-19T00:07:32.367Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyDocument")
public class PolicyDocument extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IResolvable {

    protected PolicyDocument(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyDocument(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyDocument(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocumentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyDocument() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new PolicyDocument based on the object provided.
     * <p>
     * This will accept an object created from the <code>.toJSON()</code> call
     * <p>
     * @param obj the PolicyDocument in object form. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument fromJson(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.PolicyDocument.class, "fromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class), new Object[] { obj });
    }

    /**
     * Adds a statement to the policy document.
     * <p>
     * @param statement the statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        software.amazon.jsii.Kernel.call(this, "addStatements", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Produce the Token's value at resolution time.
     * <p>
     * @param context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
    }

    /**
     * JSON-ify the document.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Encode the policy document as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Validate that all policy statements in the policy document satisfies the requirements for any policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the document is valid.
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForAnyPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForAnyPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Validate that all policy statements in the policy document satisfies the requirements for an identity-based policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the document is valid.
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForIdentityPolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForIdentityPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Validate that all policy statements in the policy document satisfies the requirements for a resource-based policy.
     * <p>
     * @return An array of validation error messages, or an empty array if the document is valid.
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateForResourcePolicy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateForResourcePolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The creation stack of this resolvable which will be appended to errors thrown during resolution.
     * <p>
     * This may return an array with a single informational element indicating how
     * to get this property populated, if it was skipped for performance reasons.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Whether the policy document contains any statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsEmpty() {
        return software.amazon.jsii.Kernel.get(this, "isEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The number of statements already added to this policy.
     * <p>
     * Can be used, for example, to generate unique "sid"s within the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getStatementCount() {
        return software.amazon.jsii.Kernel.get(this, "statementCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.PolicyDocument}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.PolicyDocument> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props;

        private Builder() {
        }

        /**
         * Automatically assign Statement Ids to all statements.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignSids Automatically assign Statement Ids to all statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignSids(final java.lang.Boolean assignSids) {
            this.props().assignSids(assignSids);
            return this;
        }

        /**
         * Try to minimize the policy by merging statements.
         * <p>
         * To avoid overrunning the maximum policy size, combine statements if they produce
         * the same result. Merging happens according to the following rules:
         * <p>
         * <ul>
         * <li>The Effect of both statements is the same</li>
         * <li>Neither of the statements have a 'Sid'</li>
         * <li>Combine Principals if the rest of the statement is exactly the same.</li>
         * <li>Combine Resources if the rest of the statement is exactly the same.</li>
         * <li>Combine Actions if the rest of the statement is exactly the same.</li>
         * <li>We will never combine NotPrincipals, NotResources or NotActions, because doing
         * so would change the meaning of the policy document.</li>
         * </ul>
         * <p>
         * Default: - false, unless the feature flag `@aws-cdk/aws-iam:minimizePolicies` is set
         * <p>
         * @return {@code this}
         * @param minimize Try to minimize the policy by merging statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimize(final java.lang.Boolean minimize) {
            this.props().minimize(minimize);
            return this;
        }

        /**
         * Initial statements to add to the policy document.
         * <p>
         * Default: - No statements
         * <p>
         * @return {@code this}
         * @param statements Initial statements to add to the policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.PolicyDocument}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.PolicyDocument build() {
            return new software.amazon.awscdk.services.iam.PolicyDocument(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyDocumentProps.Builder();
            }
            return this.props;
        }
    }
}
