package software.amazon.awscdk.services.iam;

/**
 * A SAML metadata document.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * SamlPrincipal principal = new SamlPrincipal(provider, Map.of(
 *         "StringEquals", Map.of(
 *                 "SAML:iss", "issuer")));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-19T00:07:32.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.SamlMetadataDocument")
public abstract class SamlMetadataDocument extends software.amazon.jsii.JsiiObject {

    protected SamlMetadataDocument(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SamlMetadataDocument(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SamlMetadataDocument() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create a SAML metadata document from a XML file.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlMetadataDocument fromFile(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.SamlMetadataDocument.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.SamlMetadataDocument.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Create a SAML metadata document from a XML string.
     * <p>
     * @param xml This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlMetadataDocument fromXml(final @org.jetbrains.annotations.NotNull java.lang.String xml) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.SamlMetadataDocument.class, "fromXml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.SamlMetadataDocument.class), new Object[] { java.util.Objects.requireNonNull(xml, "xml is required") });
    }

    /**
     * The XML content of the metadata document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getXml();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.iam.SamlMetadataDocument {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The XML content of the metadata document.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getXml() {
            return software.amazon.jsii.Kernel.get(this, "xml", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
