package software.amazon.awscdk.services.iam;

/**
 * A principal that represents a federated identity provider as from a OpenID Connect provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenIdConnectProvider provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clientIds(List.of("myclient1", "myclient2"))
 *         .build();
 * OpenIdConnectPrincipal principal = new OpenIdConnectPrincipal(provider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:22.246Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.OpenIdConnectPrincipal")
public class OpenIdConnectPrincipal extends software.amazon.awscdk.services.iam.WebIdentityPrincipal {

    protected OpenIdConnectPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OpenIdConnectPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param openIdConnectProvider OpenID Connect provider. This parameter is required.
     * @param conditions The conditions under which the policy is in effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenIdConnectPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(openIdConnectProvider, "openIdConnectProvider is required"), conditions });
    }

    /**
     * @param openIdConnectProvider OpenID Connect provider. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenIdConnectPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(openIdConnectProvider, "openIdConnectProvider is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }
}
