package software.amazon.awscdk.services.iam;

/**
 * Modify the Permissions Boundaries of Users and Roles in a construct tree.
 * <p>
 * <blockquote><pre>
 * IManagedPolicy policy = ManagedPolicy.fromAwsManagedPolicyName("ReadOnlyAccess");
 * PermissionsBoundary.of(this).apply(policy);
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project project;
 * PermissionsBoundary.of(project).apply(new UntrustedCodeBoundaryPolicy(this, "Boundary"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-14T16:25:22.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PermissionsBoundary")
public class PermissionsBoundary extends software.amazon.jsii.JsiiObject {

    protected PermissionsBoundary(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PermissionsBoundary(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Access the Permissions Boundaries of a construct tree.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PermissionsBoundary of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.PermissionsBoundary.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PermissionsBoundary.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Apply the given policy as Permissions Boundary to all Roles and Users in the scope.
     * <p>
     * Will override any Permissions Boundaries configured previously; in case
     * a Permission Boundary is applied in multiple scopes, the Boundary applied
     * closest to the Role wins.
     * <p>
     * @param boundaryPolicy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void apply(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy boundaryPolicy) {
        software.amazon.jsii.Kernel.call(this, "apply", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(boundaryPolicy, "boundaryPolicy is required") });
    }

    /**
     * Remove previously applied Permissions Boundaries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void clear() {
        software.amazon.jsii.Kernel.call(this, "clear", software.amazon.jsii.NativeType.VOID);
    }
}
