package software.amazon.awscdk.services.iam;

/**
 * A CloudFormation `AWS::IAM::ManagedPolicy`.
 * <p>
 * Creates a new managed policy for your AWS account .
 * <p>
 * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's default version. For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <em>IAM User Guide</em> .
 * <p>
 * As a best practice, you can validate your IAM policies. To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies</a> in the <em>IAM User Guide</em> .
 * <p>
 * For more information about managed policies in general, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline policies</a> in the <em>IAM User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * Object policyDocument;
 * CfnManagedPolicy cfnManagedPolicy = CfnManagedPolicy.Builder.create(this, "MyCfnManagedPolicy")
 *         .policyDocument(policyDocument)
 *         // the properties below are optional
 *         .description("description")
 *         .groups(List.of("groups"))
 *         .managedPolicyName("managedPolicyName")
 *         .path("path")
 *         .roles(List.of("roles"))
 *         .users(List.of("users"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-22T19:35:36.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnManagedPolicy")
public class CfnManagedPolicy extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnManagedPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnManagedPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.CfnManagedPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IAM::ManagedPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.CfnManagedPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The JSON policy document that you want to use as the content for the new policy.
     * <p>
     * You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and AWS STS character quotas</a> .
     * <p>
     * To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON policy language</a> in the <em>IAM User Guide</em> .
     * <p>
     * The <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:
     * <p>
     * <ul>
     * <li>Any printable ASCII character ranging from the space character ( <code>\ u0020</code> ) through the end of the ASCII character range</li>
     * <li>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\ u00FF</code> )</li>
     * <li>The special characters tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> )</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The JSON policy document that you want to use as the content for the new policy.
     * <p>
     * You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
     * <p>
     * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and AWS STS character quotas</a> .
     * <p>
     * To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON policy language</a> in the <em>IAM User Guide</em> .
     * <p>
     * The <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:
     * <p>
     * <ul>
     * <li>Any printable ASCII character ranging from the space character ( <code>\ u0020</code> ) through the end of the ASCII character range</li>
     * <li>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\ u00FF</code> )</li>
     * <li>The special characters tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> )</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDocument(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policyDocument", java.util.Objects.requireNonNull(value, "policyDocument is required"));
    }

    /**
     * A friendly description of the policy.
     * <p>
     * Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * <p>
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly description of the policy.
     * <p>
     * Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * <p>
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name (friendly name, not ARN) of the group to attach the policy to.
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name (friendly name, not ARN) of the group to attach the policy to.
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "groups", value);
    }

    /**
     * The friendly name of the policy.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * If you specify a name, you must specify the <code>CAPABILITY_NAMED_IAM</code> value to acknowledge your template's capabilities. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
     * <p>
     * <blockquote>
     * <p>
     * Naming an IAM resource can cause an unrecoverable error if you reuse the same template in multiple Regions. To prevent this, we recommend using <code>Fn::Join</code> and <code>AWS::Region</code> to create a Region-specific name, as in the following example: <code>{"Fn::Join": ["", [{"Ref": "AWS::Region"}, {"Ref": "MyResourceName"}]]}</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getManagedPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "managedPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The friendly name of the policy.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * If you specify a name, you must specify the <code>CAPABILITY_NAMED_IAM</code> value to acknowledge your template's capabilities. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
     * <p>
     * <blockquote>
     * <p>
     * Naming an IAM resource can cause an unrecoverable error if you reuse the same template in multiple Regions. To prevent this, we recommend using <code>Fn::Join</code> and <code>AWS::Region</code> to create a Region-specific name, as in the following example: <code>{"Fn::Join": ["", [{"Ref": "AWS::Region"}, {"Ref": "MyResourceName"}]]}</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedPolicyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "managedPolicyName", value);
    }

    /**
     * The path for the policy.
     * <p>
     * For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <em>IAM User Guide</em> .
     * <p>
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! ( <code>\ u0021</code> ) through the DEL character ( <code>\ u007F</code> ), including most punctuation characters, digits, and upper and lowercased letters.
     * <p>
     * <blockquote>
     * <p>
     * You cannot use an asterisk (*) in the path name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path for the policy.
     * <p>
     * For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <em>IAM User Guide</em> .
     * <p>
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! ( <code>\ u0021</code> ) through the DEL character ( <code>\ u007F</code> ), including most punctuation characters, digits, and upper and lowercased letters.
     * <p>
     * <blockquote>
     * <p>
     * You cannot use an asterisk (*) in the path name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "path", value);
    }

    /**
     * The name (friendly name, not ARN) of the role to attach the policy to.
     * <p>
     * This parameter allows (per its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     * <p>
     * <blockquote>
     * <p>
     * If an external policy (such as <code>AWS::IAM::Policy</code> or <code>AWS::IAM::ManagedPolicy</code> ) has a <code>Ref</code> to a role and if a resource (such as <code>AWS::ECS::Service</code> ) also has a <code>Ref</code> to the same role, add a <code>DependsOn</code> attribute to the resource to make the resource depend on the external policy. This dependency ensures that the role's policy is available throughout the resource's lifecycle. For example, when you delete a stack with an <code>AWS::ECS::Service</code> resource, the <code>DependsOn</code> attribute ensures that AWS CloudFormation deletes the <code>AWS::ECS::Service</code> resource before deleting its role's policy.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRoles() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name (friendly name, not ARN) of the role to attach the policy to.
     * <p>
     * This parameter allows (per its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     * <p>
     * <blockquote>
     * <p>
     * If an external policy (such as <code>AWS::IAM::Policy</code> or <code>AWS::IAM::ManagedPolicy</code> ) has a <code>Ref</code> to a role and if a resource (such as <code>AWS::ECS::Service</code> ) also has a <code>Ref</code> to the same role, add a <code>DependsOn</code> attribute to the resource to make the resource depend on the external policy. This dependency ensures that the role's policy is available throughout the resource's lifecycle. For example, when you delete a stack with an <code>AWS::ECS::Service</code> resource, the <code>DependsOn</code> attribute ensures that AWS CloudFormation deletes the <code>AWS::ECS::Service</code> resource before deleting its role's policy.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "roles", value);
    }

    /**
     * The name (friendly name, not ARN) of the IAM user to attach the policy to.
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name (friendly name, not ARN) of the IAM user to attach the policy to.
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "users", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.CfnManagedPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.CfnManagedPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.CfnManagedPolicyProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.CfnManagedPolicyProps.Builder();
        }

        /**
         * The JSON policy document that you want to use as the content for the new policy.
         * <p>
         * You must provide policies in JSON format in IAM. However, for AWS CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.
         * <p>
         * The maximum length of the policy document that you can pass in this operation, including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and AWS STS character quotas</a> .
         * <p>
         * To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON policy language</a> in the <em>IAM User Guide</em> .
         * <p>
         * The <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of characters consisting of the following:
         * <p>
         * <ul>
         * <li>Any printable ASCII character ranging from the space character ( <code>\ u0020</code> ) through the end of the ASCII character range</li>
         * <li>The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\ u00FF</code> )</li>
         * <li>The special characters tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> )</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param policyDocument The JSON policy document that you want to use as the content for the new policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(final java.lang.Object policyDocument) {
            this.props.policyDocument(policyDocument);
            return this;
        }

        /**
         * A friendly description of the policy.
         * <p>
         * Typically used to store information about the permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         * <p>
         * The policy description is immutable. After a value is assigned, it cannot be changed.
         * <p>
         * @return {@code this}
         * @param description A friendly description of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name (friendly name, not ARN) of the group to attach the policy to.
         * <p>
         * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
         * <p>
         * @return {@code this}
         * @param groups The name (friendly name, not ARN) of the group to attach the policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<java.lang.String> groups) {
            this.props.groups(groups);
            return this;
        }

        /**
         * The friendly name of the policy.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * If you specify a name, you must specify the <code>CAPABILITY_NAMED_IAM</code> value to acknowledge your template's capabilities. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a> .
         * <p>
         * <blockquote>
         * <p>
         * Naming an IAM resource can cause an unrecoverable error if you reuse the same template in multiple Regions. To prevent this, we recommend using <code>Fn::Join</code> and <code>AWS::Region</code> to create a Region-specific name, as in the following example: <code>{"Fn::Join": ["", [{"Ref": "AWS::Region"}, {"Ref": "MyResourceName"}]]}</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param managedPolicyName The friendly name of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(final java.lang.String managedPolicyName) {
            this.props.managedPolicyName(managedPolicyName);
            return this;
        }

        /**
         * The path for the policy.
         * <p>
         * For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <em>IAM User Guide</em> .
         * <p>
         * This parameter is optional. If it is not included, it defaults to a slash (/).
         * <p>
         * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! ( <code>\ u0021</code> ) through the DEL character ( <code>\ u007F</code> ), including most punctuation characters, digits, and upper and lowercased letters.
         * <p>
         * <blockquote>
         * <p>
         * You cannot use an asterisk (*) in the path name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param path The path for the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * The name (friendly name, not ARN) of the role to attach the policy to.
         * <p>
         * This parameter allows (per its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
         * <p>
         * <blockquote>
         * <p>
         * If an external policy (such as <code>AWS::IAM::Policy</code> or <code>AWS::IAM::ManagedPolicy</code> ) has a <code>Ref</code> to a role and if a resource (such as <code>AWS::ECS::Service</code> ) also has a <code>Ref</code> to the same role, add a <code>DependsOn</code> attribute to the resource to make the resource depend on the external policy. This dependency ensures that the role's policy is available throughout the resource's lifecycle. For example, when you delete a stack with an <code>AWS::ECS::Service</code> resource, the <code>DependsOn</code> attribute ensures that AWS CloudFormation deletes the <code>AWS::ECS::Service</code> resource before deleting its role's policy.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param roles The name (friendly name, not ARN) of the role to attach the policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.util.List<java.lang.String> roles) {
            this.props.roles(roles);
            return this;
        }

        /**
         * The name (friendly name, not ARN) of the IAM user to attach the policy to.
         * <p>
         * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
         * <p>
         * @return {@code this}
         * @param users The name (friendly name, not ARN) of the IAM user to attach the policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<java.lang.String> users) {
            this.props.users(users);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.CfnManagedPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.CfnManagedPolicy build() {
            return new software.amazon.awscdk.services.iam.CfnManagedPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
