package software.amazon.awscdk.services.iam;

/**
 * Properties for defining a `CfnOIDCProvider`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * CfnOIDCProviderProps cfnOIDCProviderProps = CfnOIDCProviderProps.builder()
 *         .thumbprintList(List.of("thumbprintList"))
 *         // the properties below are optional
 *         .clientIdList(List.of("clientIdList"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .url("url")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-22T19:35:36.571Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CfnOIDCProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnOIDCProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOIDCProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getThumbprintList();

    /**
     * A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIdList() {
        return null;
    }

    /**
     * A list of tags that are attached to the specified IAM OIDC provider.
     * <p>
     * The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <em>IAM User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The URL that the IAM OIDC provider resource object is associated with.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOIDCProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOIDCProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOIDCProviderProps> {
        java.util.List<java.lang.String> thumbprintList;
        java.util.List<java.lang.String> clientIdList;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String url;

        /**
         * Sets the value of {@link CfnOIDCProviderProps#getThumbprintList}
         * @param thumbprintList A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. This parameter is required.
         *                       For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thumbprintList(java.util.List<java.lang.String> thumbprintList) {
            this.thumbprintList = thumbprintList;
            return this;
        }

        /**
         * Sets the value of {@link CfnOIDCProviderProps#getClientIdList}
         * @param clientIdList A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object.
         *                     For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientIdList(java.util.List<java.lang.String> clientIdList) {
            this.clientIdList = clientIdList;
            return this;
        }

        /**
         * Sets the value of {@link CfnOIDCProviderProps#getTags}
         * @param tags A list of tags that are attached to the specified IAM OIDC provider.
         *             The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <em>IAM User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnOIDCProviderProps#getUrl}
         * @param url The URL that the IAM OIDC provider resource object is associated with.
         *            For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html">CreateOpenIDConnectProvider</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOIDCProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOIDCProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOIDCProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOIDCProviderProps {
        private final java.util.List<java.lang.String> thumbprintList;
        private final java.util.List<java.lang.String> clientIdList;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String url;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.thumbprintList = software.amazon.jsii.Kernel.get(this, "thumbprintList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clientIdList = software.amazon.jsii.Kernel.get(this, "clientIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.thumbprintList = java.util.Objects.requireNonNull(builder.thumbprintList, "thumbprintList is required");
            this.clientIdList = builder.clientIdList;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.url = builder.url;
        }

        @Override
        public final java.util.List<java.lang.String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final java.util.List<java.lang.String> getClientIdList() {
            return this.clientIdList;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUrl() {
            return this.url;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("thumbprintList", om.valueToTree(this.getThumbprintList()));
            if (this.getClientIdList() != null) {
                data.set("clientIdList", om.valueToTree(this.getClientIdList()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUrl() != null) {
                data.set("url", om.valueToTree(this.getUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.CfnOIDCProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOIDCProviderProps.Jsii$Proxy that = (CfnOIDCProviderProps.Jsii$Proxy) o;

            if (!thumbprintList.equals(that.thumbprintList)) return false;
            if (this.clientIdList != null ? !this.clientIdList.equals(that.clientIdList) : that.clientIdList != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.url != null ? this.url.equals(that.url) : that.url == null;
        }

        @Override
        public final int hashCode() {
            int result = this.thumbprintList.hashCode();
            result = 31 * result + (this.clientIdList != null ? this.clientIdList.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}
