/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatementProps;
import software.amazon.awscdk.services.iam.ServicePrincipalOpts;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement
extends JsiiObject {
    protected PolicyStatement(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public PolicyStatement(@Nullable PolicyStatementProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PolicyStatement() {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    public void addAccountCondition(String accountId) {
        this.jsiiCall("addAccountCondition", Void.class, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addAccountRootPrincipal() {
        this.jsiiCall("addAccountRootPrincipal", Void.class, new Object[0]);
    }

    public void addActions(String ... actions) {
        this.jsiiCall("addActions", Void.class, Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addAllResources() {
        this.jsiiCall("addAllResources", Void.class, new Object[0]);
    }

    public void addAnyPrincipal() {
        this.jsiiCall("addAnyPrincipal", Void.class, new Object[0]);
    }

    public void addArnPrincipal(String arn) {
        this.jsiiCall("addArnPrincipal", Void.class, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    public void addAwsAccountPrincipal(String accountId) {
        this.jsiiCall("addAwsAccountPrincipal", Void.class, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addCanonicalUserPrincipal(String canonicalUserId) {
        this.jsiiCall("addCanonicalUserPrincipal", Void.class, new Object[]{Objects.requireNonNull(canonicalUserId, "canonicalUserId is required")});
    }

    public void addCondition(String key, @Nullable Object value) {
        this.jsiiCall("addCondition", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addConditions(Map<String, Object> conditions) {
        this.jsiiCall("addConditions", Void.class, new Object[]{Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addFederatedPrincipal(@Nullable Object federated, Map<String, Object> conditions) {
        this.jsiiCall("addFederatedPrincipal", Void.class, new Object[]{federated, Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addPrincipals(IPrincipal ... principals) {
        this.jsiiCall("addPrincipals", Void.class, Arrays.stream(principals).toArray(Object[]::new));
    }

    public void addResources(String ... arns) {
        this.jsiiCall("addResources", Void.class, Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addServicePrincipal(String service, @Nullable ServicePrincipalOpts opts) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[]{Objects.requireNonNull(service, "service is required"), opts});
    }

    public void addServicePrincipal(String service) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @Nullable
    public Object toJSON() {
        return this.jsiiCall("toJSON", Object.class, new Object[0]);
    }

    @Nullable
    public Object toStatementJson() {
        return this.jsiiCall("toStatementJson", Object.class, new Object[0]);
    }

    public String toString() {
        return (String)this.jsiiCall("toString", String.class, new Object[0]);
    }

    public Boolean getHasPrincipal() {
        return (Boolean)this.jsiiGet("hasPrincipal", Boolean.class);
    }

    public Boolean getHasResource() {
        return (Boolean)this.jsiiGet("hasResource", Boolean.class);
    }

    public Effect getEffect() {
        return (Effect)((Object)this.jsiiGet("effect", Effect.class));
    }

    public void setEffect(Effect value) {
        this.jsiiSet("effect", (Object)Objects.requireNonNull(value, "effect is required"));
    }

    @Nullable
    public String getSid() {
        return (String)this.jsiiGet("sid", String.class);
    }

    public void setSid(@Nullable String value) {
        this.jsiiSet("sid", value);
    }
}

