/**
 * <h2>AWS Identity and Access Management Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Stable" src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define a role and add permissions to it. This will automatically create and
 * attach an IAM policy to the role:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = new Role(this, "MyRole", new RoleProps()
 *         .assumedBy(new ServicePrincipal("sns.amazonaws.com")));
 * 
 * role.addToPolicy(new PolicyStatement(new PolicyStatementProps()
 *         .resources(asList("*"))
 *         .actions(asList("lambda:InvokeFunction"))));
 * </pre></blockquote>
 * <p>
 * Define a policy and attach it to groups, users and roles. Note that it is possible to attach
 * the policy either by calling <code>xxx.attachInlinePolicy(policy)</code> or <code>policy.attachToXxx(xxx)</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * User user = new User(this, "MyUser", new UserProps().password(cdk.SecretValue.plainText("1234")));
 * Group group = new Group(this, "MyGroup");
 * 
 * Policy policy = new Policy(this, "MyPolicy");
 * policy.attachToUser(user);
 * group.attachInlinePolicy(policy);
 * </pre></blockquote>
 * <p>
 * Managed policies can be attached using <code>xxx.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Group group = new Group(this, "MyGroup");
 * group.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("policy/AdministratorAccess"));
 * </pre></blockquote>
 * <p>
 * <h3>Granting permissions to resources</h3>
 * <p>
 * Many of the AWS CDK resources have <code>grant*</code> methods that allow you to grant other resources access to that resource. As an example, the following code gives a Lambda function write permissions (Put, Update, Delete) to a DynamoDB table.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = new Function(...);
 * var table = new Table(...);
 * 
 * table.grantWriteData(fn);
 * </pre></blockquote>
 * <p>
 * The more generic <code>grant</code> method allows you to give specific permissions to a resource:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = new Function(...);
 * var table = new Table(...);
 * 
 * table.grant(fn, "dynamodb:PutItem");
 * </pre></blockquote>
 * <p>
 * The <code>grant*</code> methods accept an <code>IGrantable</code> object. This interface is implemented by IAM principlal resources (groups, users and roles) and resources that assume a role such as a Lambda function, EC2 instance or a Codebuild project.
 * <p>
 * You can find which <code>grant*</code> methods exist for a resource in the <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-construct-library.html">AWS CDK API Reference</a>.
 * <p>
 * <h3>Configuring an ExternalId</h3>
 * <p>
 * If you need to create roles that will be assumed by 3rd parties, it is generally a good idea to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">require an <code>ExternalId</code>
 * to assume them</a>.  Configuring
 * an <code>ExternalId</code> works like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Role role = new Role(this, "MyRole", new RoleProps()
 *         .assumedBy(new AccountPrincipal("123456789012"))
 *         .externalIds(asList("SUPPLY-ME")));
 * </pre></blockquote>
 * <p>
 * <h3>Principals vs Identities</h3>
 * <p>
 * When we say <em>Principal</em>, we mean an entity you grant permissions to. This
 * entity can be an AWS Service, a Role, or something more abstract such as "all
 * users in this account" or even "all users in this organization". An
 * <em>Identity</em> is an IAM representing a single IAM entity that can have
 * a policy attached, one of <code>Role</code>, <code>User</code>, or <code>Group</code>.
 * <p>
 * <h3>IAM Principals</h3>
 * <p>
 * When defining policy statements as part of an AssumeRole policy or as part of a
 * resource policy, statements would usually refer to a specific IAM principal
 * under <code>Principal</code>.
 * <p>
 * IAM principals are modeled as classes that derive from the <code>iam.PolicyPrincipal</code>
 * abstract class. Principal objects include principal type (string) and value
 * (array of string), optional set of conditions and the action that this principal
 * requires when it is used in an assume role policy document.
 * <p>
 * To add a principal to a policy statement you can either use the abstract
 * <code>statement.addPrincipal</code>, one of the concrete <code>addXxxPrincipal</code> methods:
 * <p>
 * <ul>
 * <li><code>addAwsPrincipal</code>, <code>addArnPrincipal</code> or <code>new ArnPrincipal(arn)</code> for <code>{ "AWS": arn }</code></li>
 * <li><code>addAwsAccountPrincipal</code> or <code>new AccountPrincipal(accountId)</code> for <code>{ "AWS": account-arn }</code></li>
 * <li><code>addServicePrincipal</code> or <code>new ServicePrincipal(service)</code> for <code>{ "Service": service }</code></li>
 * <li><code>addAccountRootPrincipal</code> or <code>new AccountRootPrincipal()</code> for <code>{ "AWS": { "Ref: "AWS::AccountId" } }</code></li>
 * <li><code>addCanonicalUserPrincipal</code> or <code>new CanonicalUserPrincipal(id)</code> for <code>{ "CanonicalUser": id }</code></li>
 * <li><code>addFederatedPrincipal</code> or <code>new FederatedPrincipal(federated, conditions, assumeAction)</code> for
 * <code>{ "Federated": arn }</code> and a set of optional conditions and the assume role action to use.</li>
 * <li><code>addAnyPrincipal</code> or <code>new AnyPrincipal</code> for <code>{ "AWS": "*" }</code></li>
 * </ul>
 * <p>
 * If multiple principals are added to the policy statement, they will be merged together:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var statement = new PolicyStatement();
 * statement.addServicePrincipal("cloudwatch.amazonaws.com");
 * statement.addServicePrincipal("ec2.amazonaws.com");
 * statement.addArnPrincipal("arn:aws:boom:boom");
 * </pre></blockquote>
 * <p>
 * Will result in:
 * <p>
 * <blockquote><pre>
 * {
 *   "Principal": {
 *     "Service": [ "cloudwatch.amazonaws.com", "ec2.amazonaws.com" ],
 *     "AWS": "arn:aws:boom:boom"
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * The <code>CompositePrincipal</code> class can also be used to define complex principals, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var role = Role.Builder.create(this, "MyRole")
 *         .assumedBy(new CompositePrincipal(
 *         new ServicePrincipal("ec2.amazonaws.com"),
 *         new AccountPrincipal("1818188181818187272")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Features</h3>
 * <p>
 * <ul>
 * <li>Policy name uniqueness is enforced. If two policies by the same name are attached to the same
 * principal, the attachment will fail.</li>
 * <li>Policy names are not required - the CDK logical ID will be used and ensured to be unique.</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.iam;
