package software.amazon.awscdk.services.iam;

/**
 * Managed policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T18:33:58.447Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.ManagedPolicy")
public class ManagedPolicy extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IManagedPolicy {

    protected ManagedPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.ManagedPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedPolicy(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Construct a managed policy from one of the policies that AWS manages.
     * <p>
     * For this managed policy, you only need to know the name to be able to use it.
     * <p>
     * Some managed policy names start with "service-role/", some start with
     * "job-function/", and some don't start with anything. Do include the
     * prefix when constructing this object.
     * <p>
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IManagedPolicy fromAwsManagedPolicyName(final java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromAwsManagedPolicyName", software.amazon.awscdk.services.iam.IManagedPolicy.class, new Object[] { java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Construct a customer managed policy from the managedPolicyName.
     * <p>
     * For this managed policy, you only need to know the name to be able to use it.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param managedPolicyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IManagedPolicy fromManagedPolicyName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String managedPolicyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.ManagedPolicy.class, "fromManagedPolicyName", software.amazon.awscdk.services.iam.IManagedPolicy.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(managedPolicyName, "managedPolicyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        this.jsiiCall("addStatements", Void.class, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final software.amazon.awscdk.services.iam.IGroup group) {
        this.jsiiCall("attachToGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     * <p>
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final software.amazon.awscdk.services.iam.IRole role) {
        this.jsiiCall("attachToRole", Void.class, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     * <p>
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final software.amazon.awscdk.services.iam.IUser user) {
        this.jsiiCall("attachToUser", Void.class, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * The description of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return this.jsiiGet("document", software.amazon.awscdk.services.iam.PolicyDocument.class);
    }

    /**
     * Returns the ARN of this managed policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getManagedPolicyArn() {
        return this.jsiiGet("managedPolicyArn", java.lang.String.class);
    }

    /**
     * The name of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getManagedPolicyName() {
        return this.jsiiGet("managedPolicyName", java.lang.String.class);
    }

    /**
     * The path of this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getPath() {
        return this.jsiiGet("path", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.ManagedPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the managed policy.
         * <p>
         * Typically used to store information about the
         * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         * The policy description is immutable. After a value is assigned, it cannot be changed.
         * <p>
         * Default: - empty
         * <p>
         * @return {@code this}
         * @param description A description of the managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Groups to attach this policy to.
         * <p>
         * You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
         * <p>
         * Default: - No groups.
         * <p>
         * @return {@code this}
         * @param groups Groups to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        /**
         * The name of the managed policy.
         * <p>
         * If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param managedPolicyName The name of the managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(final java.lang.String managedPolicyName) {
            this.props().managedPolicyName(managedPolicyName);
            return this;
        }

        /**
         * The path for the policy.
         * <p>
         * This parameter allows (through its regex pattern) a string of characters
         * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
         * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
         * including most punctuation characters, digits, and upper and lowercased letters.
         * <p>
         * For more information about paths, see IAM Identifiers in the IAM User Guide.
         * <p>
         * Default: - "/"
         * <p>
         * @return {@code this}
         * @param path The path for the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * Roles to attach this policy to.
         * <p>
         * You can also use <code>attachToRole(role)</code> to attach this policy to a role.
         * <p>
         * Default: - No roles.
         * <p>
         * @return {@code this}
         * @param roles Roles to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.util.List<software.amazon.awscdk.services.iam.IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        /**
         * Initial set of permissions to add to this policy document.
         * <p>
         * You can also use <code>addPermission(statement)</code> to add permissions later.
         * <p>
         * Default: - No statements.
         * <p>
         * @return {@code this}
         * @param statements Initial set of permissions to add to this policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * Users to attach this policy to.
         * <p>
         * You can also use <code>attachToUser(user)</code> to attach this policy to a user.
         * <p>
         * Default: - No users.
         * <p>
         * @return {@code this}
         * @param users Users to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            this.props().users(users);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.ManagedPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.ManagedPolicy build() {
            return new software.amazon.awscdk.services.iam.ManagedPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.ManagedPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
