package software.amazon.awscdk.services.iam;

/**
 * Interface for creating a policy statement.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T18:33:58.451Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatementProps")
@software.amazon.jsii.Jsii.Proxy(PolicyStatementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyStatementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of actions to add to the statement.
     * <p>
     * Default: - no actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getActions() {
        return null;
    }

    /**
     * Conditions to add to the statement.
     * <p>
     * Default: - no condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return null;
    }

    /**
     * Whether to allow or deny the actions in this statement.
     * <p>
     * Default: - allow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.Effect getEffect() {
        return null;
    }

    /**
     * List of not actions to add to the statement.
     * <p>
     * Default: - no not-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getNotActions() {
        return null;
    }

    /**
     * List of not principals to add to the statement.
     * <p>
     * Default: - no not principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getNotPrincipals() {
        return null;
    }

    /**
     * NotResource ARNs to add to the statement.
     * <p>
     * Default: - no not-resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getNotResources() {
        return null;
    }

    /**
     * List of principals to add to the statement.
     * <p>
     * Default: - no principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
        return null;
    }

    /**
     * Resource ARNs to add to the statement.
     * <p>
     * Default: - no resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<java.lang.String> actions;
        private java.util.Map<java.lang.String, java.lang.Object> conditions;
        private software.amazon.awscdk.services.iam.Effect effect;
        private java.util.List<java.lang.String> notActions;
        private java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals;
        private java.util.List<java.lang.String> notResources;
        private java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals;
        private java.util.List<java.lang.String> resources;

        /**
         * Sets the value of {@link PolicyStatementProps#getActions}
         * @param actions List of actions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getConditions}
         * @param conditions Conditions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.Map<java.lang.String, java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getEffect}
         * @param effect Whether to allow or deny the actions in this statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder effect(software.amazon.awscdk.services.iam.Effect effect) {
            this.effect = effect;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotActions}
         * @param notActions List of not actions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notActions(java.util.List<java.lang.String> notActions) {
            this.notActions = notActions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotPrincipals}
         * @param notPrincipals List of not principals to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notPrincipals(java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals) {
            this.notPrincipals = notPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotResources}
         * @param notResources NotResource ARNs to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notResources(java.util.List<java.lang.String> notResources) {
            this.notResources = notResources;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getPrincipals}
         * @param principals List of principals to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principals(java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals) {
            this.principals = principals;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getResources}
         * @param resources Resource ARNs to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyStatementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PolicyStatementProps build() {
            return new Jsii$Proxy(actions, conditions, effect, notActions, notPrincipals, notResources, principals, resources);
        }
    }

    /**
     * An implementation for {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyStatementProps {
        private final java.util.List<java.lang.String> actions;
        private final java.util.Map<java.lang.String, java.lang.Object> conditions;
        private final software.amazon.awscdk.services.iam.Effect effect;
        private final java.util.List<java.lang.String> notActions;
        private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals;
        private final java.util.List<java.lang.String> notResources;
        private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals;
        private final java.util.List<java.lang.String> resources;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = this.jsiiGet("actions", java.util.List.class);
            this.conditions = this.jsiiGet("conditions", java.util.Map.class);
            this.effect = this.jsiiGet("effect", software.amazon.awscdk.services.iam.Effect.class);
            this.notActions = this.jsiiGet("notActions", java.util.List.class);
            this.notPrincipals = this.jsiiGet("notPrincipals", java.util.List.class);
            this.notResources = this.jsiiGet("notResources", java.util.List.class);
            this.principals = this.jsiiGet("principals", java.util.List.class);
            this.resources = this.jsiiGet("resources", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> actions, final java.util.Map<java.lang.String, java.lang.Object> conditions, final software.amazon.awscdk.services.iam.Effect effect, final java.util.List<java.lang.String> notActions, final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals, final java.util.List<java.lang.String> notResources, final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals, final java.util.List<java.lang.String> resources) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = actions;
            this.conditions = conditions;
            this.effect = effect;
            this.notActions = notActions;
            this.notPrincipals = notPrincipals;
            this.notResources = notResources;
            this.principals = principals;
            this.resources = resources;
        }

        @Override
        public java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getConditions() {
            return this.conditions;
        }

        @Override
        public software.amazon.awscdk.services.iam.Effect getEffect() {
            return this.effect;
        }

        @Override
        public java.util.List<java.lang.String> getNotActions() {
            return this.notActions;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getNotPrincipals() {
            return this.notPrincipals;
        }

        @Override
        public java.util.List<java.lang.String> getNotResources() {
            return this.notResources;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
            return this.principals;
        }

        @Override
        public java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getEffect() != null) {
                data.set("effect", om.valueToTree(this.getEffect()));
            }
            if (this.getNotActions() != null) {
                data.set("notActions", om.valueToTree(this.getNotActions()));
            }
            if (this.getNotPrincipals() != null) {
                data.set("notPrincipals", om.valueToTree(this.getNotPrincipals()));
            }
            if (this.getNotResources() != null) {
                data.set("notResources", om.valueToTree(this.getNotResources()));
            }
            if (this.getPrincipals() != null) {
                data.set("principals", om.valueToTree(this.getPrincipals()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.PolicyStatementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyStatementProps.Jsii$Proxy that = (PolicyStatementProps.Jsii$Proxy) o;

            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.effect != null ? !this.effect.equals(that.effect) : that.effect != null) return false;
            if (this.notActions != null ? !this.notActions.equals(that.notActions) : that.notActions != null) return false;
            if (this.notPrincipals != null ? !this.notPrincipals.equals(that.notPrincipals) : that.notPrincipals != null) return false;
            if (this.notResources != null ? !this.notResources.equals(that.notResources) : that.notResources != null) return false;
            if (this.principals != null ? !this.principals.equals(that.principals) : that.principals != null) return false;
            return this.resources != null ? this.resources.equals(that.resources) : that.resources == null;
        }

        @Override
        public int hashCode() {
            int result = this.actions != null ? this.actions.hashCode() : 0;
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.effect != null ? this.effect.hashCode() : 0);
            result = 31 * result + (this.notActions != null ? this.notActions.hashCode() : 0);
            result = 31 * result + (this.notPrincipals != null ? this.notPrincipals.hashCode() : 0);
            result = 31 * result + (this.notResources != null ? this.notResources.hashCode() : 0);
            result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            return result;
        }
    }
}
