package software.amazon.awscdk.services.iam;

/**
 * Define a new IAM user.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-02-07T03:00:48.422Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.User")
public class User extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IIdentity,software.amazon.awscdk.services.iam.IUser {

    protected User(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected User(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public User(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iam.UserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public User(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing user given a username.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.iam.IUser fromUserName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String userName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.User.class, "fromUserName", software.amazon.awscdk.services.iam.IUser.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userName, "userName is required") });
    }

    /**
     * Attaches a managed policy to the user.
     * <p>
     * @param policy The managed policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addManagedPolicy(final software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        this.jsiiCall("addManagedPolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Adds this user to a group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToGroup(final software.amazon.awscdk.services.iam.IGroup group) {
        this.jsiiCall("addToGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Adds an IAM statement to the default policy.
     * <p>
     * @return true
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.Boolean addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attaches a policy to this user.
     * <p>
     * @param policy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     * An attribute that represents the user's ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUserArn() {
        return this.jsiiGet("userArn", java.lang.String.class);
    }

    /**
     * An attribute that represents the user name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUserName() {
        return this.jsiiGet("userName", java.lang.String.class);
    }

    /**
     * Returns the permissions boundary attached to this user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IManagedPolicy getPermissionsBoundary() {
        return this.jsiiGet("permissionsBoundary", software.amazon.awscdk.services.iam.IManagedPolicy.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.User}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.UserProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Groups to add this user to.
         * <p>
         * You can also use <code>addToGroup</code> to add this
         * user to a group.
         * <p>
         * Default: - No groups.
         * <p>
         * @return {@code this}
         * @param groups Groups to add this user to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        /**
         * A list of managed policies associated with this role.
         * <p>
         * You can add managed policies later using
         * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * <p>
         * Default: - No managed policies.
         * <p>
         * @return {@code this}
         * @param managedPolicies A list of managed policies associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.props().managedPolicies(managedPolicies);
            return this;
        }

        /**
         * The password for the user. This is required so the user can access the AWS Management Console.
         * <p>
         * You can use <code>SecretValue.plainText</code> to specify a password in plain text or
         * use <code>secretsmanager.Secret.fromSecretAttributes</code> to reference a secret in
         * Secrets Manager.
         * <p>
         * Default: - User won't be able to access the management console without a password.
         * <p>
         * @return {@code this}
         * @param password The password for the user. This is required so the user can access the AWS Management Console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final software.amazon.awscdk.core.SecretValue password) {
            this.props().password(password);
            return this;
        }

        /**
         * Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
         * <p>
         * If this is set to 'true', you must also specify "initialPassword".
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param passwordResetRequired Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwordResetRequired(final java.lang.Boolean passwordResetRequired) {
            this.props().passwordResetRequired(passwordResetRequired);
            return this;
        }

        /**
         * The path for the user name.
         * <p>
         * For more information about paths, see IAM
         * Identifiers in the IAM User Guide.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param path The path for the user name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * AWS supports permissions boundaries for IAM entities (users or roles).
         * <p>
         * A permissions boundary is an advanced feature for using a managed policy
         * to set the maximum permissions that an identity-based policy can grant to
         * an IAM entity. An entity's permissions boundary allows it to perform only
         * the actions that are allowed by both its identity-based policies and its
         * permissions boundaries.
         * <p>
         * Default: - No permissions boundary.
         * <p>
         * @return {@code this}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * A name for the IAM user.
         * <p>
         * For valid values, see the UserName parameter for
         * the CreateUser action in the IAM API Reference. If you don't specify a
         * name, AWS CloudFormation generates a unique physical ID and uses that ID
         * for the user name.
         * <p>
         * If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * <p>
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * <p>
         * Default: - Generated by CloudFormation (recommended)
         * <p>
         * @return {@code this}
         * @param userName A name for the IAM user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(final java.lang.String userName) {
            this.props().userName(userName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.User}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.iam.User build() {
            return new software.amazon.awscdk.services.iam.User(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.UserProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.UserProps.Builder();
            }
            return this.props;
        }
    }
}
