/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.services.iam.$Module;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatementProps;
import software.amazon.awscdk.services.iam.ServicePrincipalOpts;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement
extends JsiiObject {
    protected PolicyStatement(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PolicyStatement(PolicyStatementProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PolicyStatement() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    public void addAccountCondition(String accountId) {
        this.jsiiCall("addAccountCondition", Void.class, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addAccountRootPrincipal() {
        this.jsiiCall("addAccountRootPrincipal", Void.class, new Object[0]);
    }

    public void addActions(String ... actions) {
        this.jsiiCall("addActions", Void.class, Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addAllResources() {
        this.jsiiCall("addAllResources", Void.class, new Object[0]);
    }

    public void addAnyPrincipal() {
        this.jsiiCall("addAnyPrincipal", Void.class, new Object[0]);
    }

    public void addArnPrincipal(String arn) {
        this.jsiiCall("addArnPrincipal", Void.class, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    public void addAwsAccountPrincipal(String accountId) {
        this.jsiiCall("addAwsAccountPrincipal", Void.class, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addCanonicalUserPrincipal(String canonicalUserId) {
        this.jsiiCall("addCanonicalUserPrincipal", Void.class, new Object[]{Objects.requireNonNull(canonicalUserId, "canonicalUserId is required")});
    }

    public void addCondition(String key, Object value) {
        this.jsiiCall("addCondition", Void.class, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addConditions(Map<String, Object> conditions) {
        this.jsiiCall("addConditions", Void.class, new Object[]{Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addFederatedPrincipal(Object federated, Map<String, Object> conditions) {
        this.jsiiCall("addFederatedPrincipal", Void.class, new Object[]{federated, Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addNotActions(String ... notActions) {
        this.jsiiCall("addNotActions", Void.class, Arrays.stream(notActions).toArray(Object[]::new));
    }

    public void addNotPrincipals(IPrincipal ... notPrincipals) {
        this.jsiiCall("addNotPrincipals", Void.class, Arrays.stream(notPrincipals).toArray(Object[]::new));
    }

    public void addNotResources(String ... arns) {
        this.jsiiCall("addNotResources", Void.class, Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addPrincipals(IPrincipal ... principals) {
        this.jsiiCall("addPrincipals", Void.class, Arrays.stream(principals).toArray(Object[]::new));
    }

    public void addResources(String ... arns) {
        this.jsiiCall("addResources", Void.class, Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addServicePrincipal(String service, ServicePrincipalOpts opts) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[]{Objects.requireNonNull(service, "service is required"), opts});
    }

    public void addServicePrincipal(String service) {
        this.jsiiCall("addServicePrincipal", Void.class, new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    public Object toJSON() {
        return this.jsiiCall("toJSON", Object.class, new Object[0]);
    }

    public Object toStatementJson() {
        return this.jsiiCall("toStatementJson", Object.class, new Object[0]);
    }

    public String toString() {
        return (String)this.jsiiCall("toString", String.class, new Object[0]);
    }

    public Boolean getHasPrincipal() {
        return (Boolean)this.jsiiGet("hasPrincipal", Boolean.class);
    }

    public Boolean getHasResource() {
        return (Boolean)this.jsiiGet("hasResource", Boolean.class);
    }

    public Effect getEffect() {
        return (Effect)((Object)this.jsiiGet("effect", Effect.class));
    }

    public void setEffect(Effect value) {
        this.jsiiSet("effect", (Object)Objects.requireNonNull(value, "effect is required"));
    }

    public String getSid() {
        return (String)this.jsiiGet("sid", String.class);
    }

    public void setSid(String value) {
        this.jsiiSet("sid", value);
    }

    public static final class Builder {
        private PolicyStatementProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder actions(List<String> actions) {
            this.props().actions(actions);
            return this;
        }

        public Builder conditions(Map<String, Object> conditions) {
            this.props().conditions(conditions);
            return this;
        }

        public Builder effect(Effect effect) {
            this.props().effect(effect);
            return this;
        }

        public Builder notActions(List<String> notActions) {
            this.props().notActions(notActions);
            return this;
        }

        public Builder notPrincipals(List<IPrincipal> notPrincipals) {
            this.props().notPrincipals(notPrincipals);
            return this;
        }

        public Builder notResources(List<String> notResources) {
            this.props().notResources(notResources);
            return this;
        }

        public Builder principals(List<IPrincipal> principals) {
            this.props().principals(principals);
            return this;
        }

        public Builder resources(List<String> resources) {
            this.props().resources(resources);
            return this;
        }

        public PolicyStatement build() {
            return new PolicyStatement(this.props != null ? this.props.build() : null);
        }

        private PolicyStatementProps.Builder props() {
            if (this.props == null) {
                this.props = new PolicyStatementProps.Builder();
            }
            return this.props;
        }
    }
}

