package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation to both identity and resource.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:03.175Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.GrantOnPrincipalAndResourceOptions")
@software.amazon.jsii.Jsii.Proxy(GrantOnPrincipalAndResourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GrantOnPrincipalAndResourceOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.CommonGrantOptions {

    /**
     * The resource with a resource policy.
     * <p>
     * The statement will always be added to the resource policy.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IResourceWithPolicy getResource();

    /**
     * The principal to use in the statement for the resource policy.
     * <p>
     * Default: - the principal of the grantee will be used
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.iam.IPrincipal getResourcePolicyPrincipal() {
        return null;
    }

    /**
     * When referring to the resource in a resource policy, use this as ARN.
     * <p>
     * (Depending on the resource type, this needs to be '*' in a resource policy).
     * <p>
     * Default: Same as regular resource ARNs
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.util.List<java.lang.String> getResourceSelfArns() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        private software.amazon.awscdk.services.iam.IPrincipal resourcePolicyPrincipal;
        private java.util.List<java.lang.String> resourceSelfArns;
        private java.util.List<java.lang.String> actions;
        private software.amazon.awscdk.services.iam.IGrantable grantee;
        private java.util.List<java.lang.String> resourceArns;

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getResource}
         * @param resource The resource with a resource policy. This parameter is required.
         *                 The statement will always be added to the resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resource(software.amazon.awscdk.services.iam.IResourceWithPolicy resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getResourcePolicyPrincipal}
         * @param resourcePolicyPrincipal The principal to use in the statement for the resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourcePolicyPrincipal(software.amazon.awscdk.services.iam.IPrincipal resourcePolicyPrincipal) {
            this.resourcePolicyPrincipal = resourcePolicyPrincipal;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getResourceSelfArns}
         * @param resourceSelfArns When referring to the resource in a resource policy, use this as ARN.
         *                         (Depending on the resource type, this needs to be '*' in a resource policy).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceSelfArns(java.util.List<java.lang.String> resourceSelfArns) {
            this.resourceSelfArns = resourceSelfArns;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getActions}
         * @param actions The actions to grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getGrantee}
         * @param grantee The principal to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder grantee(software.amazon.awscdk.services.iam.IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link GrantOnPrincipalAndResourceOptions#getResourceArns}
         * @param resourceArns The resource ARNs to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantOnPrincipalAndResourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public GrantOnPrincipalAndResourceOptions build() {
            return new Jsii$Proxy(resource, resourcePolicyPrincipal, resourceSelfArns, actions, grantee, resourceArns);
        }
    }

    /**
     * An implementation for {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantOnPrincipalAndResourceOptions {
        private final software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        private final software.amazon.awscdk.services.iam.IPrincipal resourcePolicyPrincipal;
        private final java.util.List<java.lang.String> resourceSelfArns;
        private final java.util.List<java.lang.String> actions;
        private final software.amazon.awscdk.services.iam.IGrantable grantee;
        private final java.util.List<java.lang.String> resourceArns;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resource = this.jsiiGet("resource", software.amazon.awscdk.services.iam.IResourceWithPolicy.class);
            this.resourcePolicyPrincipal = this.jsiiGet("resourcePolicyPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
            this.resourceSelfArns = this.jsiiGet("resourceSelfArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.actions = this.jsiiGet("actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.grantee = this.jsiiGet("grantee", software.amazon.awscdk.services.iam.IGrantable.class);
            this.resourceArns = this.jsiiGet("resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.iam.IResourceWithPolicy resource, final software.amazon.awscdk.services.iam.IPrincipal resourcePolicyPrincipal, final java.util.List<java.lang.String> resourceSelfArns, final java.util.List<java.lang.String> actions, final software.amazon.awscdk.services.iam.IGrantable grantee, final java.util.List<java.lang.String> resourceArns) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resource = java.util.Objects.requireNonNull(resource, "resource is required");
            this.resourcePolicyPrincipal = resourcePolicyPrincipal;
            this.resourceSelfArns = resourceSelfArns;
            this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
            this.grantee = java.util.Objects.requireNonNull(grantee, "grantee is required");
            this.resourceArns = java.util.Objects.requireNonNull(resourceArns, "resourceArns is required");
        }

        @Override
        public software.amazon.awscdk.services.iam.IResourceWithPolicy getResource() {
            return this.resource;
        }

        @Override
        public software.amazon.awscdk.services.iam.IPrincipal getResourcePolicyPrincipal() {
            return this.resourcePolicyPrincipal;
        }

        @Override
        public java.util.List<java.lang.String> getResourceSelfArns() {
            return this.resourceSelfArns;
        }

        @Override
        public java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.grantee;
        }

        @Override
        public java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resource", om.valueToTree(this.getResource()));
            if (this.getResourcePolicyPrincipal() != null) {
                data.set("resourcePolicyPrincipal", om.valueToTree(this.getResourcePolicyPrincipal()));
            }
            if (this.getResourceSelfArns() != null) {
                data.set("resourceSelfArns", om.valueToTree(this.getResourceSelfArns()));
            }
            data.set("actions", om.valueToTree(this.getActions()));
            data.set("grantee", om.valueToTree(this.getGrantee()));
            data.set("resourceArns", om.valueToTree(this.getResourceArns()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.GrantOnPrincipalAndResourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantOnPrincipalAndResourceOptions.Jsii$Proxy that = (GrantOnPrincipalAndResourceOptions.Jsii$Proxy) o;

            if (!resource.equals(that.resource)) return false;
            if (this.resourcePolicyPrincipal != null ? !this.resourcePolicyPrincipal.equals(that.resourcePolicyPrincipal) : that.resourcePolicyPrincipal != null) return false;
            if (this.resourceSelfArns != null ? !this.resourceSelfArns.equals(that.resourceSelfArns) : that.resourceSelfArns != null) return false;
            if (!actions.equals(that.actions)) return false;
            if (!grantee.equals(that.grantee)) return false;
            return this.resourceArns.equals(that.resourceArns);
        }

        @Override
        public int hashCode() {
            int result = this.resource.hashCode();
            result = 31 * result + (this.resourcePolicyPrincipal != null ? this.resourcePolicyPrincipal.hashCode() : 0);
            result = 31 * result + (this.resourceSelfArns != null ? this.resourceSelfArns.hashCode() : 0);
            result = 31 * result + (this.actions.hashCode());
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.resourceArns.hashCode());
            return result;
        }
    }
}
