/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.iam.ManagedPolicyProps;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.ManagedPolicy")
public class ManagedPolicy
extends Resource
implements IManagedPolicy {
    protected ManagedPolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedPolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ManagedPolicy(@NotNull Construct scope, @NotNull String id, @Nullable ManagedPolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ManagedPolicy(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IManagedPolicy fromAwsManagedPolicyName(@NotNull String managedPolicyName) {
        return (IManagedPolicy)JsiiObject.jsiiStaticCall(ManagedPolicy.class, (String)"fromAwsManagedPolicyName", IManagedPolicy.class, (Object[])new Object[]{Objects.requireNonNull(managedPolicyName, "managedPolicyName is required")});
    }

    @NotNull
    public static IManagedPolicy fromManagedPolicyArn(@NotNull Construct scope, @NotNull String id, @NotNull String managedPolicyArn) {
        return (IManagedPolicy)JsiiObject.jsiiStaticCall(ManagedPolicy.class, (String)"fromManagedPolicyArn", IManagedPolicy.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(managedPolicyArn, "managedPolicyArn is required")});
    }

    @NotNull
    public static IManagedPolicy fromManagedPolicyName(@NotNull Construct scope, @NotNull String id, @NotNull String managedPolicyName) {
        return (IManagedPolicy)JsiiObject.jsiiStaticCall(ManagedPolicy.class, (String)"fromManagedPolicyName", IManagedPolicy.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(managedPolicyName, "managedPolicyName is required")});
    }

    public void addStatements(PolicyStatement ... statement) {
        this.jsiiCall("addStatements", NativeType.VOID, Arrays.stream(statement).toArray(Object[]::new));
    }

    public void attachToGroup(@NotNull IGroup group) {
        this.jsiiCall("attachToGroup", NativeType.VOID, new Object[]{Objects.requireNonNull(group, "group is required")});
    }

    public void attachToRole(@NotNull IRole role) {
        this.jsiiCall("attachToRole", NativeType.VOID, new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    public void attachToUser(@NotNull IUser user) {
        this.jsiiCall("attachToUser", NativeType.VOID, new Object[]{Objects.requireNonNull(user, "user is required")});
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    @NotNull
    public PolicyDocument getDocument() {
        return (PolicyDocument)((Object)this.jsiiGet("document", PolicyDocument.class));
    }

    @Override
    @NotNull
    public String getManagedPolicyArn() {
        return (String)this.jsiiGet("managedPolicyArn", String.class);
    }

    @NotNull
    public String getManagedPolicyName() {
        return (String)this.jsiiGet("managedPolicyName", String.class);
    }

    @NotNull
    public String getPath() {
        return (String)this.jsiiGet("path", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private ManagedPolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder document(PolicyDocument document) {
            this.props().document(document);
            return this;
        }

        public Builder groups(List<IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        public Builder managedPolicyName(String managedPolicyName) {
            this.props().managedPolicyName(managedPolicyName);
            return this;
        }

        public Builder path(String path) {
            this.props().path(path);
            return this;
        }

        public Builder roles(List<IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        public Builder statements(List<PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        public Builder users(List<IUser> users) {
            this.props().users(users);
            return this;
        }

        public ManagedPolicy build() {
            return new ManagedPolicy(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ManagedPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new ManagedPolicyProps.Builder();
            }
            return this.props;
        }
    }
}

