package software.amazon.awscdk.services.iam;

/**
 * Represents a principal that has multiple types of principals.
 * <p>
 * A composite principal cannot
 * have conditions. i.e. multiple ServicePrincipals that form a composite principal
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-28T11:03:59.504Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.CompositePrincipal")
public class CompositePrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected CompositePrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CompositePrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param principals This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CompositePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalBase... principals) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(principals).toArray(Object[]::new));
    }

    /**
     * Adds IAM principals to the composite principal.
     * <p>
     * Composite principals cannot have
     * conditions.
     * <p>
     * @param principals IAM principals that will be added to the composite principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.CompositePrincipal addPrincipals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalBase... principals) {
        return this.jsiiCall("addPrincipals", software.amazon.awscdk.services.iam.CompositePrincipal.class, java.util.Arrays.<Object>stream(principals).toArray(Object[]::new));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }
}
