package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM inline policy document.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:10.020Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyProps")
@software.amazon.jsii.Jsii.Proxy(PolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Force creation of an `AWS::IAM::Policy`.
     * <p>
     * Unless set to <code>true</code>, this <code>Policy</code> construct will not materialize to an
     * <code>AWS::IAM::Policy</code> CloudFormation resource in case it would have no effect
     * (for example, if it remains unattached to an IAM identity or if it has no
     * statements). This is generally desired behavior, since it prevents
     * creating invalid--and hence undeployable--CloudFormation templates.
     * <p>
     * In cases where you know the policy must be created and it is actually
     * an error if no statements have been added to it, you can se this to <code>true</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForce() {
        return null;
    }

    /**
     * Groups to attach this policy to.
     * <p>
     * You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
     * <p>
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
        return null;
    }

    /**
     * The name of the policy.
     * <p>
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * <p>
     * Default: - Uses the logical ID of the policy resource, which is ensured
     * to be unique within the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyName() {
        return null;
    }

    /**
     * Roles to attach this policy to.
     * <p>
     * You can also use <code>attachToRole(role)</code> to attach this policy to a role.
     * <p>
     * Default: - No roles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
        return null;
    }

    /**
     * Initial set of permissions to add to this policy document.
     * <p>
     * You can also use <code>addStatements(...statement)</code> to add permissions later.
     * <p>
     * Default: - No statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
        return null;
    }

    /**
     * Users to attach this policy to.
     * <p>
     * You can also use <code>attachToUser(user)</code> to attach this policy to a user.
     * <p>
     * Default: - No users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean force;
        private java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private java.lang.String policyName;
        private java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Sets the value of {@link PolicyProps#getForce}
         * @param force Force creation of an `AWS::IAM::Policy`.
         *              Unless set to <code>true</code>, this <code>Policy</code> construct will not materialize to an
         *              <code>AWS::IAM::Policy</code> CloudFormation resource in case it would have no effect
         *              (for example, if it remains unattached to an IAM identity or if it has no
         *              statements). This is generally desired behavior, since it prevents
         *              creating invalid--and hence undeployable--CloudFormation templates.
         *              <p>
         *              In cases where you know the policy must be created and it is actually
         *              an error if no statements have been added to it, you can se this to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(java.lang.Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link PolicyProps#getGroups}
         * @param groups Groups to attach this policy to.
         *               You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of {@link PolicyProps#getPolicyName}
         * @param policyName The name of the policy.
         *                   If you specify multiple policies for an entity,
         *                   specify unique names. For example, if you specify a list of policies for
         *                   an IAM role, each policy must have a unique name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link PolicyProps#getRoles}
         * @param roles Roles to attach this policy to.
         *              You can also use <code>attachToRole(role)</code> to attach this policy to a role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.util.List<software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Sets the value of {@link PolicyProps#getStatements}
         * @param statements Initial set of permissions to add to this policy document.
         *                   You can also use <code>addStatements(...statement)</code> to add permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.statements = statements;
            return this;
        }

        /**
         * Sets the value of {@link PolicyProps#getUsers}
         * @param users Users to attach this policy to.
         *              You can also use <code>attachToUser(user)</code> to attach this policy to a user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            this.users = users;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PolicyProps build() {
            return new Jsii$Proxy(force, groups, policyName, roles, statements, users);
        }
    }

    /**
     * An implementation for {@link PolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyProps {
        private final java.lang.Boolean force;
        private final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private final java.lang.String policyName;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private final java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.force = this.jsiiGet("force", java.lang.Boolean.class);
            this.groups = this.jsiiGet("groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGroup.class)));
            this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            this.roles = this.jsiiGet("roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class)));
            this.statements = this.jsiiGet("statements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.users = this.jsiiGet("users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IUser.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean force, final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups, final java.lang.String policyName, final java.util.List<software.amazon.awscdk.services.iam.IRole> roles, final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements, final java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.force = force;
            this.groups = groups;
            this.policyName = policyName;
            this.roles = roles;
            this.statements = statements;
            this.users = users;
        }

        @Override
        public java.lang.Boolean getForce() {
            return this.force;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.groups;
        }

        @Override
        public java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.statements;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.users;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getForce() != null) {
                data.set("force", om.valueToTree(this.getForce()));
            }
            if (this.getGroups() != null) {
                data.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getStatements() != null) {
                data.set("statements", om.valueToTree(this.getStatements()));
            }
            if (this.getUsers() != null) {
                data.set("users", om.valueToTree(this.getUsers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.PolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyProps.Jsii$Proxy that = (PolicyProps.Jsii$Proxy) o;

            if (this.force != null ? !this.force.equals(that.force) : that.force != null) return false;
            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.statements != null ? !this.statements.equals(that.statements) : that.statements != null) return false;
            return this.users != null ? this.users.equals(that.users) : that.users == null;
        }

        @Override
        public int hashCode() {
            int result = this.force != null ? this.force.hashCode() : 0;
            result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
            result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
            return result;
        }
    }
}
