package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:14:18.599Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the managed policy.
     * 
     * Typically used to store information about the
     * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     * 
     * Default: - empty
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();
    /**
     * Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
     * 
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups();
    /**
     * The name of the managed policy.
     * 
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * 
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getManagedPolicyName();
    /**
     * The path for the policy.
     * 
     * This parameter allows (through its regex pattern) a string of characters
     * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
     * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
     * including most punctuation characters, digits, and upper and lowercased letters.
     * 
     * For more information about paths, see IAM Identifiers in the IAM User Guide.
     * 
     * Default: - "/"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();
    /**
     * Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
     * 
     * Default: - No roles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles();
    /**
     * Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
     * 
     * Default: - No statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements();
    /**
     * Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
     * 
     * Default: - No users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers();

    /**
     * @return a {@link Builder} of {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IGroup> _groups;
        @javax.annotation.Nullable
        private java.lang.String _managedPolicyName;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IRole> _roles;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _statements;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.IUser> _users;

        /**
         * Sets the value of Description
         * @param value A description of the managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of Groups
         * @param value Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IGroup> value) {
            this._groups = value;
            return this;
        }
        /**
         * Sets the value of ManagedPolicyName
         * @param value The name of the managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withManagedPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._managedPolicyName = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The path for the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Roles
         * @param value Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IRole> value) {
            this._roles = value;
            return this;
        }
        /**
         * Sets the value of Statements
         * @param value Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._statements = value;
            return this;
        }
        /**
         * Sets the value of Users
         * @param value Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.IUser> value) {
            this._users = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ManagedPolicyProps build() {
            return new ManagedPolicyProps() {
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IGroup> $groups = _groups;
                @javax.annotation.Nullable
                private final java.lang.String $managedPolicyName = _managedPolicyName;
                @javax.annotation.Nullable
                private final java.lang.String $path = _path;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IRole> $roles = _roles;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $statements = _statements;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.iam.IUser> $users = _users;

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
                    return this.$groups;
                }

                @Override
                public java.lang.String getManagedPolicyName() {
                    return this.$managedPolicyName;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
                    return this.$roles;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
                    return this.$statements;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
                    return this.$users;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getGroups() != null) {
                        obj.set("groups", om.valueToTree(this.getGroups()));
                    }
                    if (this.getManagedPolicyName() != null) {
                        obj.set("managedPolicyName", om.valueToTree(this.getManagedPolicyName()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree(this.getPath()));
                    }
                    if (this.getRoles() != null) {
                        obj.set("roles", om.valueToTree(this.getRoles()));
                    }
                    if (this.getStatements() != null) {
                        obj.set("statements", om.valueToTree(this.getStatements()));
                    }
                    if (this.getUsers() != null) {
                        obj.set("users", om.valueToTree(this.getUsers()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.ManagedPolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * A description of the managed policy.
         * 
         * Typically used to store information about the
         * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         * The policy description is immutable. After a value is assigned, it cannot be changed.
         * 
         * Default: - empty
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
         * 
         * Default: - No groups.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }

        /**
         * The name of the managed policy.
         * 
         * If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * 
         * Default: - A name is automatically generated.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getManagedPolicyName() {
            return this.jsiiGet("managedPolicyName", java.lang.String.class);
        }

        /**
         * The path for the policy.
         * 
         * This parameter allows (through its regex pattern) a string of characters
         * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
         * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
         * including most punctuation characters, digits, and upper and lowercased letters.
         * 
         * For more information about paths, see IAM Identifiers in the IAM User Guide.
         * 
         * Default: - "/"
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
         * 
         * Default: - No roles.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.jsiiGet("roles", java.util.List.class);
        }

        /**
         * Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
         * 
         * Default: - No statements.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.jsiiGet("statements", java.util.List.class);
        }

        /**
         * Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
         * 
         * Default: - No users.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.jsiiGet("users", java.util.List.class);
        }
    }
}
