/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.RoleProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LazyRoleProps
extends JsiiSerializable,
RoleProps {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IPrincipal _assumedBy;
        @Nullable
        private String _externalId;
        @Nullable
        private List<String> _externalIds;
        @Nullable
        private Map<String, PolicyDocument> _inlinePolicies;
        @Nullable
        private List<IManagedPolicy> _managedPolicies;
        @Nullable
        private Duration _maxSessionDuration;
        @Nullable
        private String _path;
        @Nullable
        private IManagedPolicy _permissionsBoundary;
        @Nullable
        private String _roleName;

        public Builder withAssumedBy(IPrincipal value) {
            this._assumedBy = Objects.requireNonNull(value, "assumedBy is required");
            return this;
        }

        @Deprecated
        public Builder withExternalId(@Nullable String value) {
            this._externalId = value;
            return this;
        }

        public Builder withExternalIds(@Nullable List<String> value) {
            this._externalIds = value;
            return this;
        }

        public Builder withInlinePolicies(@Nullable Map<String, PolicyDocument> value) {
            this._inlinePolicies = value;
            return this;
        }

        public Builder withManagedPolicies(@Nullable List<IManagedPolicy> value) {
            this._managedPolicies = value;
            return this;
        }

        public Builder withMaxSessionDuration(@Nullable Duration value) {
            this._maxSessionDuration = value;
            return this;
        }

        public Builder withPath(@Nullable String value) {
            this._path = value;
            return this;
        }

        public Builder withPermissionsBoundary(@Nullable IManagedPolicy value) {
            this._permissionsBoundary = value;
            return this;
        }

        public Builder withRoleName(@Nullable String value) {
            this._roleName = value;
            return this;
        }

        public LazyRoleProps build() {
            return new LazyRoleProps(){
                private final IPrincipal $assumedBy;
                @Nullable
                private final String $externalId;
                @Nullable
                private final List<String> $externalIds;
                @Nullable
                private final Map<String, PolicyDocument> $inlinePolicies;
                @Nullable
                private final List<IManagedPolicy> $managedPolicies;
                @Nullable
                private final Duration $maxSessionDuration;
                @Nullable
                private final String $path;
                @Nullable
                private final IManagedPolicy $permissionsBoundary;
                @Nullable
                private final String $roleName;
                {
                    this.$assumedBy = Objects.requireNonNull(_assumedBy, "assumedBy is required");
                    this.$externalId = _externalId;
                    this.$externalIds = _externalIds;
                    this.$inlinePolicies = _inlinePolicies;
                    this.$managedPolicies = _managedPolicies;
                    this.$maxSessionDuration = _maxSessionDuration;
                    this.$path = _path;
                    this.$permissionsBoundary = _permissionsBoundary;
                    this.$roleName = _roleName;
                }

                @Override
                public IPrincipal getAssumedBy() {
                    return this.$assumedBy;
                }

                @Override
                public String getExternalId() {
                    return this.$externalId;
                }

                @Override
                public List<String> getExternalIds() {
                    return this.$externalIds;
                }

                @Override
                public Map<String, PolicyDocument> getInlinePolicies() {
                    return this.$inlinePolicies;
                }

                @Override
                public List<IManagedPolicy> getManagedPolicies() {
                    return this.$managedPolicies;
                }

                @Override
                public Duration getMaxSessionDuration() {
                    return this.$maxSessionDuration;
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public IManagedPolicy getPermissionsBoundary() {
                    return this.$permissionsBoundary;
                }

                @Override
                public String getRoleName() {
                    return this.$roleName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("assumedBy", om.valueToTree((Object)this.getAssumedBy()));
                    if (this.getExternalId() != null) {
                        obj.set("externalId", om.valueToTree((Object)this.getExternalId()));
                    }
                    if (this.getExternalIds() != null) {
                        obj.set("externalIds", om.valueToTree(this.getExternalIds()));
                    }
                    if (this.getInlinePolicies() != null) {
                        obj.set("inlinePolicies", om.valueToTree(this.getInlinePolicies()));
                    }
                    if (this.getManagedPolicies() != null) {
                        obj.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
                    }
                    if (this.getMaxSessionDuration() != null) {
                        obj.set("maxSessionDuration", om.valueToTree((Object)this.getMaxSessionDuration()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree((Object)this.getPath()));
                    }
                    if (this.getPermissionsBoundary() != null) {
                        obj.set("permissionsBoundary", om.valueToTree((Object)this.getPermissionsBoundary()));
                    }
                    if (this.getRoleName() != null) {
                        obj.set("roleName", om.valueToTree((Object)this.getRoleName()));
                    }
                    return obj;
                }
            };
        }
    }
}

