/**
 * <h2>AWS Identity and Access Management Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define a role and add permissions to it. This will automatically create and
 * attach an IAM policy to the role:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Role role = new Role(this, "MyRole", new RoleProps()
 *         .assumedBy(new ServicePrincipal("sns.amazonaws.com")));
 * 
 * role.addToPolicy(new PolicyStatement(new PolicyStatementProps()
 *         .resources(asList("*"))
 *         .actions(asList("lambda:InvokeFunction"))));
 * </pre></blockquote>
 * <p>
 * Define a policy and attach it to groups, users and roles. Note that it is possible to attach
 * the policy either by calling <code>xxx.attachInlinePolicy(policy)</code> or <code>policy.attachToXxx(xxx)</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * User user = new User(this, "MyUser", new UserProps().password(cdk.SecretValue.plainText("1234")));
 * Group group = new Group(this, "MyGroup");
 * 
 * Policy policy = new Policy(this, "MyPolicy");
 * policy.attachToUser(user);
 * group.attachInlinePolicy(policy);
 * </pre></blockquote>
 * <p>
 * Managed policies can be attached using <code>xxx.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Group group = new Group(this, "MyGroup");
 * group.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("AdministratorAccess"));
 * </pre></blockquote>
 * <p>
 * <h3>Granting permissions to resources</h3>
 * <p>
 * Many of the AWS CDK resources have <code>grant*</code> methods that allow you to grant other resources access to that resource. As an example, the following code gives a Lambda function write permissions (Put, Update, Delete) to a DynamoDB table.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = new Function(...);
 * var table = new Table(...);
 * 
 * table.grantWriteData(fn);
 * </pre></blockquote>
 * <p>
 * The more generic <code>grant</code> method allows you to give specific permissions to a resource:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = new Function(...);
 * var table = new Table(...);
 * 
 * table.grant(fn, "dynamodb:PutItem");
 * </pre></blockquote>
 * <p>
 * The <code>grant*</code> methods accept an <code>IGrantable</code> object. This interface is implemented by IAM principlal resources (groups, users and roles) and resources that assume a role such as a Lambda function, EC2 instance or a Codebuild project.
 * <p>
 * You can find which <code>grant*</code> methods exist for a resource in the <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-construct-library.html">AWS CDK API Reference</a>.
 * <p>
 * <h3>Roles</h3>
 * <p>
 * Many AWS resources require <em>Roles</em> to operate. These Roles define the AWS API
 * calls an instance or other AWS service is allowed to make.
 * <p>
 * Creating Roles and populating them with the right permissions <em>Statements</em> is
 * a necessary but tedious part of setting up AWS infrastructure. In order to
 * help you focus on your business logic, CDK will take care of creating
 * roles and populating them with least-privilege permissions automatically.
 * <p>
 * All constructs that require Roles will create one for you if don't specify
 * one at construction time. Permissions will be added to that role
 * automatically if you associate the construct with other constructs from the
 * AWS Construct Library (for example, if you tell an <em>AWS CodePipeline</em> to trigger
 * an <em>AWS Lambda Function</em>, the Pipeline's Role will automatically get
 * <code>lambda:InvokeFunction</code> permissions on that particular Lambda Function),
 * or if you explicitly grant permissions using <code>grant</code> functions (see the
 * previous section).
 * <p>
 * <h4>Opting out of automatic permissions management</h4>
 * <p>
 * You may prefer to manage a Role's permissions yourself instead of having the
 * CDK automatically manage them for you. This may happen in one of the
 * following cases:
 * <p>
 * <ul>
 * <li>You don't like the permissions that CDK automatically generates and
 * want to substitute your own set.</li>
 * <li>The least-permissions policy that the CDK generates is becoming too
 * big for IAM to store, and you need to add some wildcards to keep the
 * policy size down.</li>
 * </ul>
 * <p>
 * To prevent constructs from updating your Role's policy, pass the object
 * returned by <code>myRole.withoutPolicyUpdates()</code> instead of <code>myRole</code> itself.
 * <p>
 * For example, to have an AWS CodePipeline <em>not</em> automatically add the required
 * permissions to trigger the expected targets, do the following:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("codepipeline.amazonaws.com"))
 *         // custom description if desired
 *         .description("This is a custom role...")
 *         .build();
 * 
 * Pipeline.Builder.create(this, "Pipeline")
 *         // Give the Pipeline an immutable view of the Role
 *         .role(role.withoutPolicyUpdates())
 *         .build();
 * 
 * // You now have to manage the Role policies yourself
 * role.addToPolicy(PolicyStatement.Builder.create()
 *         .action(asList())
 *         .resource(asList())
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h4>Using existing roles</h4>
 * <p>
 * If there are Roles in your account that have already been created which you
 * would like to use in your CDK application, you can use <code>Role.fromRoleArn</code> to
 * import them, as follows:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var role = iam.Role.fromRoleArn(this, "Role", "arn:aws:iam::123456789012:role/MyExistingRole", Map.of(
 *         // Set 'mutable' to 'false' to use the role as-is and prevent adding new
 *         // policies to it. The default is 'true', which means the role may be
 *         // modified as part of the deployment.
 *         "mutable", false));
 * </pre></blockquote>
 * <p>
 * <h3>Configuring an ExternalId</h3>
 * <p>
 * If you need to create Roles that will be assumed by third parties, it is generally a good idea to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">require an <code>ExternalId</code>
 * to assume them</a>.  Configuring
 * an <code>ExternalId</code> works like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Role role = new Role(this, "MyRole", new RoleProps()
 *         .assumedBy(new AccountPrincipal("123456789012"))
 *         .externalIds(asList("SUPPLY-ME")));
 * </pre></blockquote>
 * <p>
 * <h3>Principals vs Identities</h3>
 * <p>
 * When we say <em>Principal</em>, we mean an entity you grant permissions to. This
 * entity can be an AWS Service, a Role, or something more abstract such as "all
 * users in this account" or even "all users in this organization". An
 * <em>Identity</em> is an IAM representing a single IAM entity that can have
 * a policy attached, one of <code>Role</code>, <code>User</code>, or <code>Group</code>.
 * <p>
 * <h3>IAM Principals</h3>
 * <p>
 * When defining policy statements as part of an AssumeRole policy or as part of a
 * resource policy, statements would usually refer to a specific IAM principal
 * under <code>Principal</code>.
 * <p>
 * IAM principals are modeled as classes that derive from the <code>iam.PolicyPrincipal</code>
 * abstract class. Principal objects include principal type (string) and value
 * (array of string), optional set of conditions and the action that this principal
 * requires when it is used in an assume role policy document.
 * <p>
 * To add a principal to a policy statement you can either use the abstract
 * <code>statement.addPrincipal</code>, one of the concrete <code>addXxxPrincipal</code> methods:
 * <p>
 * <ul>
 * <li><code>addAwsPrincipal</code>, <code>addArnPrincipal</code> or <code>new ArnPrincipal(arn)</code> for <code>{ "AWS": arn }</code></li>
 * <li><code>addAwsAccountPrincipal</code> or <code>new AccountPrincipal(accountId)</code> for <code>{ "AWS": account-arn }</code></li>
 * <li><code>addServicePrincipal</code> or <code>new ServicePrincipal(service)</code> for <code>{ "Service": service }</code></li>
 * <li><code>addAccountRootPrincipal</code> or <code>new AccountRootPrincipal()</code> for <code>{ "AWS": { "Ref: "AWS::AccountId" } }</code></li>
 * <li><code>addCanonicalUserPrincipal</code> or <code>new CanonicalUserPrincipal(id)</code> for <code>{ "CanonicalUser": id }</code></li>
 * <li><code>addFederatedPrincipal</code> or <code>new FederatedPrincipal(federated, conditions, assumeAction)</code> for
 * <code>{ "Federated": arn }</code> and a set of optional conditions and the assume role action to use.</li>
 * <li><code>addAnyPrincipal</code> or <code>new AnyPrincipal</code> for <code>{ "AWS": "*" }</code></li>
 * </ul>
 * <p>
 * If multiple principals are added to the policy statement, they will be merged together:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var statement = new PolicyStatement();
 * statement.addServicePrincipal("cloudwatch.amazonaws.com");
 * statement.addServicePrincipal("ec2.amazonaws.com");
 * statement.addArnPrincipal("arn:aws:boom:boom");
 * </pre></blockquote>
 * <p>
 * Will result in:
 * <p>
 * <blockquote><pre>
 * {
 *   "Principal": {
 *     "Service": [ "cloudwatch.amazonaws.com", "ec2.amazonaws.com" ],
 *     "AWS": "arn:aws:boom:boom"
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * The <code>CompositePrincipal</code> class can also be used to define complex principals, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var role = Role.Builder.create(this, "MyRole")
 *         .assumedBy(new CompositePrincipal(
 *         new ServicePrincipal("ec2.amazonaws.com"),
 *         new AccountPrincipal("1818188181818187272")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <code>PrincipalWithConditions</code> class can be used to add conditions to a
 * principal, especially those that don't take a <code>conditions</code> parameter in their
 * constructor. The <code>principal.withConditions()</code> method can be used to create a
 * <code>PrincipalWithConditions</code> from an existing principal, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var principal = new iam.AccountPrincipal('123456789000').withConditions(Map.of("StringEquals", Map.of("foo", "baz")));
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: If you need to define an IAM condition that uses a token (such as a
 * deploy-time attribute of another resource) in a JSON map key, use <code>CfnJson</code> to
 * render this condition. See <a href="./test/integ-condition-with-ref.ts">this test</a> for
 * an example.
 * <p>
 * </blockquote>
 * <p>
 * The <code>WebIdentityPrincipal</code> class can be used as a principal for web identities like
 * Cognito, Amazon, Google or Facebook, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var principal = new iam.WebIdentityPrincipal('cognito-identity.amazonaws.com').withConditions(Map.of(
 *         "StringEquals", Map.of("cognito-identity.amazonaws.com:aud", "us-east-2:12345678-abcd-abcd-abcd-123456"),
 *         "ForAnyValue:StringLike", Map.of("cognito-identity.amazonaws.com:amr", "unauthenticated")));
 * </pre></blockquote>
 * <p>
 * <h3>Parsing JSON Policy Documents</h3>
 * <p>
 * The <code>PolicyDocument.fromJson</code> and <code>PolicyStatement.fromJson</code> static methods can be used to parse JSON objects. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * __object policyDocument = Map.of(
 *         "Version", "2012-10-17",
 *         "Statement", asList(Map.of(
 *                 "Sid", "FirstStatement",
 *                 "Effect", "Allow",
 *                 "Action", asList("iam:ChangePassword"),
 *                 "Resource", "*"), Map.of(
 *                 "Sid", "SecondStatement",
 *                 "Effect", "Allow",
 *                 "Action", "s3:ListAllMyBuckets",
 *                 "Resource", "*"), Map.of(
 *                 "Sid", "ThirdStatement",
 *                 "Effect", "Allow",
 *                 "Action", asList("s3:List*", "s3:Get*"),
 *                 "Resource", asList("arn:aws:s3:::confidential-data", "arn:aws:s3:::confidential-data/*"),
 *                 "Condition", Map.of("Bool", Map.of("aws:MultiFactorAuthPresent", "true")))));
 * 
 * var newPolicyDocument = PolicyDocument.fromJson(policyDocument);
 * </pre></blockquote>
 * <p>
 * <h3>OpenID Connect Providers</h3>
 * <p>
 * OIDC identity providers are entities in IAM that describe an external identity
 * provider (IdP) service that supports the <a href="http://openid.net/connect">OpenID Connect</a> (OIDC) standard, such
 * as Google or Salesforce. You use an IAM OIDC identity provider when you want to
 * establish trust between an OIDC-compatible IdP and your AWS account. This is
 * useful when creating a mobile app or web application that requires access to AWS
 * resources, but you don't want to create custom sign-in code or manage your own
 * user identities. For more information about this scenario, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About Web
 * Identity Federation</a> and the relevant documentation in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/open-id.html">Amazon Cognito
 * Identity Pools Developer Guide</a>.
 * <p>
 * The following examples defines an OpenID Connect provider. Two client IDs
 * (audiences) are will be able to send authentication requests to
 * https://openid/connect.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clients(asList("myclient1", "myclient2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can specify an optional list of <code>thumbprints</code>. If not specified, the
 * thumbprint of the root certificate authority (CA) will automatically be obtained
 * from the host as described
 * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html">here</a>.
 * <p>
 * Once you define an OpenID connect provider, you can use it with AWS services
 * that expect an IAM OIDC provider. For example, when you define an <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/open-id.html">Amazon
 * Cognito identity
 * pool</a>
 * you can reference the provider's ARN as follows:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * CfnIdentityPool.Builder.create(this, "IdentityPool")
 *         .openIdConnectProviderARNs(asList(provider.getOpenIdConnectProviderArn()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * The <code>OpenIdConnectPrincipal</code> class can be used as a principal used with a <code>OpenIdConnectProvider</code>, for example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var provider = OpenIdConnectProvider.Builder.create(this, "MyProvider")
 *         .url("https://openid/connect")
 *         .clients(asList("myclient1", "myclient2"))
 *         .build();
 * var principal = new OpenIdConnectPrincipal(provider);
 * </pre></blockquote>
 * <p>
 * <h3>Features</h3>
 * <p>
 * <ul>
 * <li>Policy name uniqueness is enforced. If two policies by the same name are attached to the same
 * principal, the attachment will fail.</li>
 * <li>Policy names are not required - the CDK logical ID will be used and ensured to be unique.</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.iam;
