package software.amazon.awscdk.services.iam;

/**
 * Represents an IAM Group.
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-06-01T16:52:34.679Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.IGroup")
@software.amazon.jsii.Jsii.Proxy(IGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IIdentity {

    /**
     * Returns the IAM Group ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupArn();

    /**
     * Returns the IAM Group Name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the IAM Group ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getGroupArn() {
            return this.jsiiGet("groupArn", java.lang.String.class);
        }

        /**
         * Returns the IAM Group Name.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Attaches a managed policy to this principal.
         * <p>
         * @param policy The managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy policy) {
            this.jsiiCall("addManagedPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Attaches an inline policy to this principal.
         * <p>
         * This is the same as calling <code>policy.addToXxx(principal)</code>.
         * <p>
         * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void attachInlinePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add to the policy of this principal.
         * <p>
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         * @deprecated Use `addToPrincipalPolicy` instead.
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Add to the policy of this principal.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPrincipalPolicy", software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
