package software.amazon.awscdk.services.iam;

/**
 * An IAM principal with additional conditions specifying when the policy is in effect.
 * <p>
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T00:02:09.462Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PrincipalWithConditions")
public class PrincipalWithConditions extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IPrincipal {

    protected PrincipalWithConditions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PrincipalWithConditions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param principal This parameter is required.
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PrincipalWithConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal principal, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(principal, "principal is required"), java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Add a condition to the principal.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiCall("addCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Adds multiple conditions to the principal.
     * <p>
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConditions(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        this.jsiiCall("addConditions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPrincipalPolicy", software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * JSON-ify the principal.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> toJSON() {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("toJSON", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)))));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The conditions under which the policy is in effect.
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">the IAM documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }
}
