package software.amazon.awscdk.services.iam;

/**
 * Interface for creating a policy statement.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T14:10:51.832Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatementProps")
@software.amazon.jsii.Jsii.Proxy(PolicyStatementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyStatementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of actions to add to the statement.
     * <p>
     * Default: - no actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getActions() {
        return null;
    }

    /**
     * Conditions to add to the statement.
     * <p>
     * Default: - no condition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return null;
    }

    /**
     * Whether to allow or deny the actions in this statement.
     * <p>
     * Default: Effect.ALLOW
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.Effect getEffect() {
        return null;
    }

    /**
     * List of not actions to add to the statement.
     * <p>
     * Default: - no not-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotActions() {
        return null;
    }

    /**
     * List of not principals to add to the statement.
     * <p>
     * Default: - no not principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getNotPrincipals() {
        return null;
    }

    /**
     * NotResource ARNs to add to the statement.
     * <p>
     * Default: - no not-resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotResources() {
        return null;
    }

    /**
     * List of principals to add to the statement.
     * <p>
     * Default: - no principals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
        return null;
    }

    /**
     * Resource ARNs to add to the statement.
     * <p>
     * Default: - no resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return null;
    }

    /**
     * The Sid (statement ID) is an optional identifier that you provide for the policy statement.
     * <p>
     * You can assign a Sid value to each statement in a
     * statement array. In services that let you specify an ID element, such as
     * SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
     * IAM, the Sid value must be unique within a JSON policy.
     * <p>
     * Default: - no sid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSid() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyStatementProps> {
        private java.util.List<java.lang.String> actions;
        private java.util.Map<java.lang.String, java.lang.Object> conditions;
        private software.amazon.awscdk.services.iam.Effect effect;
        private java.util.List<java.lang.String> notActions;
        private java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals;
        private java.util.List<java.lang.String> notResources;
        private java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals;
        private java.util.List<java.lang.String> resources;
        private java.lang.String sid;

        /**
         * Sets the value of {@link PolicyStatementProps#getActions}
         * @param actions List of actions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getConditions}
         * @param conditions Conditions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.Map<java.lang.String, java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getEffect}
         * @param effect Whether to allow or deny the actions in this statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder effect(software.amazon.awscdk.services.iam.Effect effect) {
            this.effect = effect;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotActions}
         * @param notActions List of not actions to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notActions(java.util.List<java.lang.String> notActions) {
            this.notActions = notActions;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotPrincipals}
         * @param notPrincipals List of not principals to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notPrincipals(java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals) {
            this.notPrincipals = notPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getNotResources}
         * @param notResources NotResource ARNs to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notResources(java.util.List<java.lang.String> notResources) {
            this.notResources = notResources;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getPrincipals}
         * @param principals List of principals to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principals(java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals) {
            this.principals = principals;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getResources}
         * @param resources Resource ARNs to add to the statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link PolicyStatementProps#getSid}
         * @param sid The Sid (statement ID) is an optional identifier that you provide for the policy statement.
         *            You can assign a Sid value to each statement in a
         *            statement array. In services that let you specify an ID element, such as
         *            SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
         *            IAM, the Sid value must be unique within a JSON policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sid(java.lang.String sid) {
            this.sid = sid;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyStatementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyStatementProps build() {
            return new Jsii$Proxy(actions, conditions, effect, notActions, notPrincipals, notResources, principals, resources, sid);
        }
    }

    /**
     * An implementation for {@link PolicyStatementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyStatementProps {
        private final java.util.List<java.lang.String> actions;
        private final java.util.Map<java.lang.String, java.lang.Object> conditions;
        private final software.amazon.awscdk.services.iam.Effect effect;
        private final java.util.List<java.lang.String> notActions;
        private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals;
        private final java.util.List<java.lang.String> notResources;
        private final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals;
        private final java.util.List<java.lang.String> resources;
        private final java.lang.String sid;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = this.jsiiGet("actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.conditions = this.jsiiGet("conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.effect = this.jsiiGet("effect", software.amazon.awscdk.services.iam.Effect.class);
            this.notActions = this.jsiiGet("notActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.notPrincipals = this.jsiiGet("notPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class)));
            this.notResources = this.jsiiGet("notResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.principals = this.jsiiGet("principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class)));
            this.resources = this.jsiiGet("resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sid = this.jsiiGet("sid", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> actions, final java.util.Map<java.lang.String, java.lang.Object> conditions, final software.amazon.awscdk.services.iam.Effect effect, final java.util.List<java.lang.String> notActions, final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals, final java.util.List<java.lang.String> notResources, final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals, final java.util.List<java.lang.String> resources, final java.lang.String sid) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = actions;
            this.conditions = conditions;
            this.effect = effect;
            this.notActions = notActions;
            this.notPrincipals = notPrincipals;
            this.notResources = notResources;
            this.principals = principals;
            this.resources = resources;
            this.sid = sid;
        }

        @Override
        public java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getConditions() {
            return this.conditions;
        }

        @Override
        public software.amazon.awscdk.services.iam.Effect getEffect() {
            return this.effect;
        }

        @Override
        public java.util.List<java.lang.String> getNotActions() {
            return this.notActions;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getNotPrincipals() {
            return this.notPrincipals;
        }

        @Override
        public java.util.List<java.lang.String> getNotResources() {
            return this.notResources;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IPrincipal> getPrincipals() {
            return this.principals;
        }

        @Override
        public java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public java.lang.String getSid() {
            return this.sid;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getEffect() != null) {
                data.set("effect", om.valueToTree(this.getEffect()));
            }
            if (this.getNotActions() != null) {
                data.set("notActions", om.valueToTree(this.getNotActions()));
            }
            if (this.getNotPrincipals() != null) {
                data.set("notPrincipals", om.valueToTree(this.getNotPrincipals()));
            }
            if (this.getNotResources() != null) {
                data.set("notResources", om.valueToTree(this.getNotResources()));
            }
            if (this.getPrincipals() != null) {
                data.set("principals", om.valueToTree(this.getPrincipals()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getSid() != null) {
                data.set("sid", om.valueToTree(this.getSid()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.PolicyStatementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyStatementProps.Jsii$Proxy that = (PolicyStatementProps.Jsii$Proxy) o;

            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.effect != null ? !this.effect.equals(that.effect) : that.effect != null) return false;
            if (this.notActions != null ? !this.notActions.equals(that.notActions) : that.notActions != null) return false;
            if (this.notPrincipals != null ? !this.notPrincipals.equals(that.notPrincipals) : that.notPrincipals != null) return false;
            if (this.notResources != null ? !this.notResources.equals(that.notResources) : that.notResources != null) return false;
            if (this.principals != null ? !this.principals.equals(that.principals) : that.principals != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            return this.sid != null ? this.sid.equals(that.sid) : that.sid == null;
        }

        @Override
        public int hashCode() {
            int result = this.actions != null ? this.actions.hashCode() : 0;
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.effect != null ? this.effect.hashCode() : 0);
            result = 31 * result + (this.notActions != null ? this.notActions.hashCode() : 0);
            result = 31 * result + (this.notPrincipals != null ? this.notPrincipals.hashCode() : 0);
            result = 31 * result + (this.notResources != null ? this.notResources.hashCode() : 0);
            result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
            return result;
        }
    }
}
