package software.amazon.awscdk.services.iam;

/**
 * An IAM role that only gets attached to the construct tree once it gets used, not before.
 * <p>
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-09T15:22:34.574Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.LazyRole")
public class LazyRole extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iam.IRole {

    protected LazyRole(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LazyRole(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LazyRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.LazyRoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Attaches a managed policy to this role.
     * <p>
     * @param policy The managed policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy policy) {
        this.jsiiCall("addManagedPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a permission to the role's default policy document.
     * <p>
     * If there is no default policy attached to this role, it will be created.
     * <p>
     * @param statement The permission statement to add to the policy document. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return this.jsiiCall("addToPrincipalPolicy", software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attaches a policy to this role.
     * <p>
     * @param policy The policy to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachInlinePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Grant the actions defined in actions to the identity Principal on this resource.
     * <p>
     * @param identity This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant permissions to the given principal to pass this role.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPassRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal identity) {
        return this.jsiiCall("grantPassRole", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return this.jsiiGet("assumeRoleAction", java.lang.String.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * Returns the stable and unique string identifying the role (i.e. AIDAJQABLZS4A3QDU576Q).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleId() {
        return this.jsiiGet("roleId", java.lang.String.class);
    }

    /**
     * Returns the name of this role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleName() {
        return this.jsiiGet("roleName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.LazyRole}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.LazyRole> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.LazyRoleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.LazyRoleProps.Builder();
        }

        /**
         * The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role.
         * <p>
         * You can later modify the assume role policy document by accessing it via
         * the <code>assumeRolePolicy</code> property.
         * <p>
         * @return {@code this}
         * @param assumedBy The IAM principal (i.e. `new ServicePrincipal('sns.amazonaws.com')`) which can assume this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumedBy(final software.amazon.awscdk.services.iam.IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        /**
         * A description of the role.
         * <p>
         * It can be up to 1000 characters long.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * ID that the role assumer needs to provide when assuming this role.
         * <p>
         * If the configured and provided external IDs do not match, the
         * AssumeRole operation will fail.
         * <p>
         * Default: No external ID required
         * <p>
         * @return {@code this}
         * @deprecated see {@link externalIds}
         * @param externalId ID that the role assumer needs to provide when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder externalId(final java.lang.String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        /**
         * List of IDs that the role assumer needs to provide one of when assuming this role.
         * <p>
         * If the configured and provided external IDs do not match, the
         * AssumeRole operation will fail.
         * <p>
         * Default: No external ID required
         * <p>
         * @return {@code this}
         * @param externalIds List of IDs that the role assumer needs to provide one of when assuming this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalIds(final java.util.List<java.lang.String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        /**
         * A list of named policies to inline into this role.
         * <p>
         * These policies will be
         * created with the role, whereas those added by <code>addToPolicy</code> are added
         * using a separate CloudFormation resource (allowing a way around circular
         * dependencies that could otherwise be introduced).
         * <p>
         * Default: - No policy is inlined in the Role resource.
         * <p>
         * @return {@code this}
         * @param inlinePolicies A list of named policies to inline into this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlinePolicies(final java.util.Map<java.lang.String, software.amazon.awscdk.services.iam.PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        /**
         * A list of managed policies associated with this role.
         * <p>
         * You can add managed policies later using
         * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * <p>
         * Default: - No managed policies.
         * <p>
         * @return {@code this}
         * @param managedPolicies A list of managed policies associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        /**
         * The maximum session duration that you want to set for the specified role.
         * <p>
         * This setting can have a value from 1 hour (3600sec) to 12 (43200sec) hours.
         * <p>
         * Anyone who assumes the role from the AWS CLI or API can use the
         * DurationSeconds API parameter or the duration-seconds CLI parameter to
         * request a longer session. The MaxSessionDuration setting determines the
         * maximum duration that can be requested using the DurationSeconds
         * parameter.
         * <p>
         * If users don't specify a value for the DurationSeconds parameter, their
         * security credentials are valid for one hour by default. This applies when
         * you use the AssumeRole* API operations or the assume-role* CLI operations
         * but does not apply when you use those operations to create a console URL.
         * <p>
         * Default: Duration.hours(1)
         * <p>
         * @return {@code this}
         * @param maxSessionDuration The maximum session duration that you want to set for the specified role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSessionDuration(final software.amazon.awscdk.core.Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        /**
         * The path associated with this role.
         * <p>
         * For information about IAM paths, see
         * Friendly Names and Paths in IAM User Guide.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param path The path associated with this role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * AWS supports permissions boundaries for IAM entities (users or roles).
         * <p>
         * A permissions boundary is an advanced feature for using a managed policy
         * to set the maximum permissions that an identity-based policy can grant to
         * an IAM entity. An entity's permissions boundary allows it to perform only
         * the actions that are allowed by both its identity-based policies and its
         * permissions boundaries.
         * <p>
         * Default: - No permissions boundary.
         * <p>
         * @return {@code this}
         * @param permissionsBoundary AWS supports permissions boundaries for IAM entities (users or roles). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final software.amazon.awscdk.services.iam.IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * A name for the IAM role.
         * <p>
         * For valid values, see the RoleName parameter for
         * the CreateRole action in the IAM API Reference.
         * <p>
         * IMPORTANT: If you specify a name, you cannot perform updates that require
         * replacement of this resource. You can perform updates that require no or
         * some interruption. If you must replace the resource, specify a new name.
         * <p>
         * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         * acknowledge your template's capabilities. For more information, see
         * Acknowledging IAM Resources in AWS CloudFormation Templates.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
         * for the group name.
         * <p>
         * @return {@code this}
         * @param roleName A name for the IAM role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleName(final java.lang.String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.LazyRole}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.LazyRole build() {
            return new software.amazon.awscdk.services.iam.LazyRole(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
