/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult;
import software.amazon.awscdk.services.iam.FromRoleArnOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.Policy;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.PrincipalPolicyFragment;
import software.amazon.awscdk.services.iam.RoleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.Role")
public class Role
extends Resource
implements IRole {
    protected Role(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Role(@NotNull Construct scope, @NotNull String id, @NotNull RoleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRole fromRoleArn(@NotNull Construct scope, @NotNull String id, @NotNull String roleArn, @Nullable FromRoleArnOptions options) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleArn", IRole.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleArn, "roleArn is required"), options});
    }

    @NotNull
    public static IRole fromRoleArn(@NotNull Construct scope, @NotNull String id, @NotNull String roleArn) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleArn", IRole.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleArn, "roleArn is required")});
    }

    @Override
    public void addManagedPolicy(@NotNull IManagedPolicy policy) {
        this.jsiiCall("addManagedPolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public Boolean addToPolicy(@NotNull PolicyStatement statement) {
        return (Boolean)this.jsiiCall("addToPolicy", Boolean.class, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public AddToPrincipalPolicyResult addToPrincipalPolicy(@NotNull PolicyStatement statement) {
        return (AddToPrincipalPolicyResult)this.jsiiCall("addToPrincipalPolicy", AddToPrincipalPolicyResult.class, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void attachInlinePolicy(@NotNull Policy policy) {
        this.jsiiCall("attachInlinePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IPrincipal grantee, String ... actions) {
        return (Grant)((Object)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantPassRole(@NotNull IPrincipal identity) {
        return (Grant)((Object)this.jsiiCall("grantPassRole", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @NotNull
    public IRole withoutPolicyUpdates() {
        return (IRole)this.jsiiCall("withoutPolicyUpdates", IRole.class, new Object[0]);
    }

    @Override
    @NotNull
    public String getAssumeRoleAction() {
        return (String)this.jsiiGet("assumeRoleAction", String.class);
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    @Override
    @NotNull
    public PrincipalPolicyFragment getPolicyFragment() {
        return (PrincipalPolicyFragment)((Object)this.jsiiGet("policyFragment", PrincipalPolicyFragment.class));
    }

    @Override
    @NotNull
    public String getRoleArn() {
        return (String)this.jsiiGet("roleArn", String.class);
    }

    @NotNull
    public String getRoleId() {
        return (String)this.jsiiGet("roleId", String.class);
    }

    @Override
    @NotNull
    public String getRoleName() {
        return (String)this.jsiiGet("roleName", String.class);
    }

    @Nullable
    public PolicyDocument getAssumeRolePolicy() {
        return (PolicyDocument)((Object)this.jsiiGet("assumeRolePolicy", PolicyDocument.class));
    }

    @Nullable
    public IManagedPolicy getPermissionsBoundary() {
        return (IManagedPolicy)this.jsiiGet("permissionsBoundary", IManagedPolicy.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Role> {
        private final Construct scope;
        private final String id;
        private final RoleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new RoleProps.Builder();
        }

        public Builder assumedBy(IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        @Deprecated
        public Builder externalId(String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        public Builder externalIds(List<String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        public Builder inlinePolicies(Map<String, PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        public Builder managedPolicies(List<IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        public Builder maxSessionDuration(Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        public Builder path(String path) {
            this.props.path(path);
            return this;
        }

        public Builder permissionsBoundary(IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder roleName(String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        public Role build() {
            return new Role(this.scope, this.id, this.props.build());
        }
    }
}

