/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.IResolveContext;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.PolicyDocumentProps;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.PolicyDocument")
public class PolicyDocument
extends JsiiObject
implements IResolvable {
    protected PolicyDocument(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyDocument(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PolicyDocument(@Nullable PolicyDocumentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PolicyDocument() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static PolicyDocument fromJson(@NotNull Object obj) {
        return (PolicyDocument)((Object)JsiiObject.jsiiStaticCall(PolicyDocument.class, (String)"fromJson", PolicyDocument.class, (Object[])new Object[]{obj}));
    }

    public void addStatements(PolicyStatement ... statement) {
        this.jsiiCall("addStatements", NativeType.VOID, Arrays.stream(statement).toArray(Object[]::new));
    }

    @NotNull
    public Object resolve(@NotNull IResolveContext context) {
        return this.jsiiCall("resolve", Object.class, new Object[]{Objects.requireNonNull(context, "context is required")});
    }

    @NotNull
    public Object toJSON() {
        return this.jsiiCall("toJSON", Object.class, new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)this.jsiiCall("toString", String.class, new Object[0]);
    }

    @NotNull
    public List<String> getCreationStack() {
        return Collections.unmodifiableList((List)this.jsiiGet("creationStack", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Boolean getIsEmpty() {
        return (Boolean)this.jsiiGet("isEmpty", Boolean.class);
    }

    @NotNull
    public Number getStatementCount() {
        return (Number)this.jsiiGet("statementCount", Number.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PolicyDocument> {
        private PolicyDocumentProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder assignSids(Boolean assignSids) {
            this.props().assignSids(assignSids);
            return this;
        }

        public Builder statements(List<PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        public PolicyDocument build() {
            return new PolicyDocument(this.props != null ? this.props.build() : null);
        }

        private PolicyDocumentProps.Builder props() {
            if (this.props == null) {
                this.props = new PolicyDocumentProps.Builder();
            }
            return this.props;
        }
    }
}

