package software.amazon.awscdk.services.iam;

/**
 * Initialization properties for `OpenIdConnectProvider`.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-18T01:27:07.385Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.OpenIdConnectProviderProps")
@software.amazon.jsii.Jsii.Proxy(OpenIdConnectProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OpenIdConnectProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The URL of the identity provider.
     * <p>
     * The URL must begin with https:// and
     * should correspond to the iss claim in the provider's OpenID Connect ID
     * tokens. Per the OIDC standard, path components are allowed but query
     * parameters are not. Typically the URL consists of only a hostname, like
     * https://server.example.org or https://example.com.
     * <p>
     * You cannot register the same provider multiple times in a single AWS
     * account. If you try to submit a URL that has already been used for an
     * OpenID Connect provider in the AWS account, you will get an error.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUrl();

    /**
     * A list of client IDs (also known as audiences).
     * <p>
     * When a mobile or web app
     * registers with an OpenID Connect provider, they establish a value that
     * identifies the application. (This is the value that's sent as the client_id
     * parameter on OAuth requests.)
     * <p>
     * You can register multiple client IDs with the same provider. For example,
     * you might have multiple applications that use the same OIDC provider. You
     * cannot register more than 100 client IDs with a single IAM OIDC provider.
     * <p>
     * Client IDs are up to 255 characters long.
     * <p>
     * Default: - no clients are allowed
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClientIds() {
        return null;
    }

    /**
     * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
     * <p>
     * Typically this list includes only one entry. However, IAM lets you have up
     * to five thumbprints for an OIDC provider. This lets you maintain multiple
     * thumbprints if the identity provider is rotating certificates.
     * <p>
     * The server certificate thumbprint is the hex-encoded SHA-1 hash value of
     * the X.509 certificate used by the domain where the OpenID Connect provider
     * makes its keys available. It is always a 40-character string.
     * <p>
     * You must provide at least one thumbprint when creating an IAM OIDC
     * provider. For example, assume that the OIDC provider is server.example.com
     * and the provider stores its keys at
     * https://keys.server.example.com/openid-connect. In that case, the
     * thumbprint string would be the hex-encoded SHA-1 hash value of the
     * certificate used by https://keys.server.example.com.
     * <p>
     * Default: - If no thumbprints are specified (an empty array or `undefined`),
     * the thumbprint of the root certificate authority will be obtained from the
     * provider's server as described in https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getThumbprints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OpenIdConnectProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenIdConnectProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<OpenIdConnectProviderProps> {
        private java.lang.String url;
        private java.util.List<java.lang.String> clientIds;
        private java.util.List<java.lang.String> thumbprints;

        /**
         * Sets the value of {@link OpenIdConnectProviderProps#getUrl}
         * @param url The URL of the identity provider. This parameter is required.
         *            The URL must begin with https:// and
         *            should correspond to the iss claim in the provider's OpenID Connect ID
         *            tokens. Per the OIDC standard, path components are allowed but query
         *            parameters are not. Typically the URL consists of only a hostname, like
         *            https://server.example.org or https://example.com.
         *            <p>
         *            You cannot register the same provider multiple times in a single AWS
         *            account. If you try to submit a URL that has already been used for an
         *            OpenID Connect provider in the AWS account, you will get an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder url(java.lang.String url) {
            this.url = url;
            return this;
        }

        /**
         * Sets the value of {@link OpenIdConnectProviderProps#getClientIds}
         * @param clientIds A list of client IDs (also known as audiences).
         *                  When a mobile or web app
         *                  registers with an OpenID Connect provider, they establish a value that
         *                  identifies the application. (This is the value that's sent as the client_id
         *                  parameter on OAuth requests.)
         *                  <p>
         *                  You can register multiple client IDs with the same provider. For example,
         *                  you might have multiple applications that use the same OIDC provider. You
         *                  cannot register more than 100 client IDs with a single IAM OIDC provider.
         *                  <p>
         *                  Client IDs are up to 255 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientIds(java.util.List<java.lang.String> clientIds) {
            this.clientIds = clientIds;
            return this;
        }

        /**
         * Sets the value of {@link OpenIdConnectProviderProps#getThumbprints}
         * @param thumbprints A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates.
         *                    Typically this list includes only one entry. However, IAM lets you have up
         *                    to five thumbprints for an OIDC provider. This lets you maintain multiple
         *                    thumbprints if the identity provider is rotating certificates.
         *                    <p>
         *                    The server certificate thumbprint is the hex-encoded SHA-1 hash value of
         *                    the X.509 certificate used by the domain where the OpenID Connect provider
         *                    makes its keys available. It is always a 40-character string.
         *                    <p>
         *                    You must provide at least one thumbprint when creating an IAM OIDC
         *                    provider. For example, assume that the OIDC provider is server.example.com
         *                    and the provider stores its keys at
         *                    https://keys.server.example.com/openid-connect. In that case, the
         *                    thumbprint string would be the hex-encoded SHA-1 hash value of the
         *                    certificate used by https://keys.server.example.com.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder thumbprints(java.util.List<java.lang.String> thumbprints) {
            this.thumbprints = thumbprints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenIdConnectProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public OpenIdConnectProviderProps build() {
            return new Jsii$Proxy(url, clientIds, thumbprints);
        }
    }

    /**
     * An implementation for {@link OpenIdConnectProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIdConnectProviderProps {
        private final java.lang.String url;
        private final java.util.List<java.lang.String> clientIds;
        private final java.util.List<java.lang.String> thumbprints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.url = this.jsiiGet("url", java.lang.String.class);
            this.clientIds = this.jsiiGet("clientIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.thumbprints = this.jsiiGet("thumbprints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String url, final java.util.List<java.lang.String> clientIds, final java.util.List<java.lang.String> thumbprints) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.url = java.util.Objects.requireNonNull(url, "url is required");
            this.clientIds = clientIds;
            this.thumbprints = thumbprints;
        }

        @Override
        public java.lang.String getUrl() {
            return this.url;
        }

        @Override
        public java.util.List<java.lang.String> getClientIds() {
            return this.clientIds;
        }

        @Override
        public java.util.List<java.lang.String> getThumbprints() {
            return this.thumbprints;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("url", om.valueToTree(this.getUrl()));
            if (this.getClientIds() != null) {
                data.set("clientIds", om.valueToTree(this.getClientIds()));
            }
            if (this.getThumbprints() != null) {
                data.set("thumbprints", om.valueToTree(this.getThumbprints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.OpenIdConnectProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenIdConnectProviderProps.Jsii$Proxy that = (OpenIdConnectProviderProps.Jsii$Proxy) o;

            if (!url.equals(that.url)) return false;
            if (this.clientIds != null ? !this.clientIds.equals(that.clientIds) : that.clientIds != null) return false;
            return this.thumbprints != null ? this.thumbprints.equals(that.thumbprints) : that.thumbprints == null;
        }

        @Override
        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (this.clientIds != null ? this.clientIds.hashCode() : 0);
            result = 31 * result + (this.thumbprints != null ? this.thumbprints.hashCode() : 0);
            return result;
        }
    }
}
