package software.amazon.awscdk.services.iam;

/**
 * Represents a statement in an IAM policy document.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-20T10:46:26.601Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement extends software.amazon.jsii.JsiiObject {

    protected PolicyStatement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyStatementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PolicyStatement() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new PolicyStatement based on the object provided.
     * <p>
     * This will accept an object created from the <code>.toJSON()</code> call
     * <p>
     * @param obj the PolicyStatement in object form. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement fromJson(final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.PolicyStatement.class, "fromJson", software.amazon.awscdk.services.iam.PolicyStatement.class, new Object[] { obj });
    }

    /**
     * Add a condition that limits to a given account.
     * <p>
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountCondition(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        this.jsiiCall("addAccountCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * Adds an AWS account root user principal to this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAccountRootPrincipal() {
        this.jsiiCall("addAccountRootPrincipal", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Specify allowed actions into the "Action" section of the policy statement.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
     * @param actions actions that will be allowed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addActions(final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        this.jsiiCall("addActions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Adds a ``"*"`` resource to this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAllResources() {
        this.jsiiCall("addAllResources", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Adds all identities in all accounts ("*") to this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAnyPrincipal() {
        this.jsiiCall("addAnyPrincipal", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Specify a principal using the ARN  identifier of the principal.
     * <p>
     * You cannot specify IAM groups and instance profiles as principals.
     * <p>
     * @param arn ARN identifier of AWS account, IAM user, or IAM role (i.e. arn:aws:iam::123456789012:user/user-name). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addArnPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        this.jsiiCall("addArnPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Specify AWS account ID as the principal entity to the "Principal" section of a policy statement.
     * <p>
     * @param accountId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAwsAccountPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String accountId) {
        this.jsiiCall("addAwsAccountPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(accountId, "accountId is required") });
    }

    /**
     * Adds a canonical user ID principal to this policy document.
     * <p>
     * @param canonicalUserId unique identifier assigned by AWS for every account. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCanonicalUserPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String canonicalUserId) {
        this.jsiiCall("addCanonicalUserPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(canonicalUserId, "canonicalUserId is required") });
    }

    /**
     * Add a condition to the Policy.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiCall("addCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Add multiple conditions to the Policy.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConditions(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        this.jsiiCall("addConditions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Adds a federated identity provider such as Amazon Cognito to this policy statement.
     * <p>
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com'). This parameter is required.
     * @param conditions The conditions under which the policy is in effect. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addFederatedPrincipal(final @org.jetbrains.annotations.NotNull java.lang.Object federated, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        this.jsiiCall("addFederatedPrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { federated, java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Explicitly allow all actions except the specified list of actions into the "NotAction" section of the policy document.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html
     * @param notActions actions that will be denied. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotActions(final @org.jetbrains.annotations.NotNull java.lang.String... notActions) {
        this.jsiiCall("addNotActions", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(notActions).toArray(Object[]::new));
    }

    /**
     * Specify principals that is not allowed or denied access to the "NotPrincipal" section of a policy statement.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html
     * @param notPrincipals IAM principals that will be denied access. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotPrincipals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal... notPrincipals) {
        this.jsiiCall("addNotPrincipals", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(notPrincipals).toArray(Object[]::new));
    }

    /**
     * Specify resources that this policy statement will not apply to in the "NotResource" section of this policy statement.
     * <p>
     * All resources except the specified list will be matched.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement does not apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotResources(final @org.jetbrains.annotations.NotNull java.lang.String... arns) {
        this.jsiiCall("addNotResources", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds principals to the "Principal" section of a policy statement.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
     * @param principals IAM principals that will be added. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPrincipals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal... principals) {
        this.jsiiCall("addPrincipals", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(principals).toArray(Object[]::new));
    }

    /**
     * Specify resources that this policy statement applies into the "Resource" section of this policy statement.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_resource.html
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement applies to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResources(final @org.jetbrains.annotations.NotNull java.lang.String... arns) {
        this.jsiiCall("addResources", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * Adds a service principal to this policy statement.
     * <p>
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     * @param opts options for adding the service principal (such as specifying a principal in a different region).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.ServicePrincipalOpts opts) {
        this.jsiiCall("addServicePrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), opts });
    }

    /**
     * Adds a service principal to this policy statement.
     * <p>
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addServicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        this.jsiiCall("addServicePrincipal", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * JSON-ify the statement.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJSON() {
        return this.jsiiCall("toJSON", java.lang.Object.class);
    }

    /**
     * JSON-ify the policy statement.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toStatementJson() {
        return this.jsiiCall("toStatementJson", java.lang.Object.class);
    }

    /**
     * String representation of this policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Indicates if this permission has a "Principal" section.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasPrincipal() {
        return this.jsiiGet("hasPrincipal", java.lang.Boolean.class);
    }

    /**
     * Indicates if this permission as at least one resource associated with it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasResource() {
        return this.jsiiGet("hasResource", java.lang.Boolean.class);
    }

    /**
     * Whether to allow or deny the actions in this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Effect getEffect() {
        return this.jsiiGet("effect", software.amazon.awscdk.services.iam.Effect.class);
    }

    /**
     * Whether to allow or deny the actions in this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEffect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Effect value) {
        this.jsiiSet("effect", java.util.Objects.requireNonNull(value, "effect is required"));
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSid() {
        return this.jsiiGet("sid", java.lang.String.class);
    }

    /**
     * Statement ID for this statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSid(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sid", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.PolicyStatement}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.PolicyStatement> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.iam.PolicyStatementProps.Builder props;

        private Builder() {
        }

        /**
         * List of actions to add to the statement.
         * <p>
         * Default: - no actions
         * <p>
         * @return {@code this}
         * @param actions List of actions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<java.lang.String> actions) {
            this.props().actions(actions);
            return this;
        }

        /**
         * Conditions to add to the statement.
         * <p>
         * Default: - no condition
         * <p>
         * @return {@code this}
         * @param conditions Conditions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.Map<java.lang.String, java.lang.Object> conditions) {
            this.props().conditions(conditions);
            return this;
        }

        /**
         * Whether to allow or deny the actions in this statement.
         * <p>
         * Default: Effect.ALLOW
         * <p>
         * @return {@code this}
         * @param effect Whether to allow or deny the actions in this statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder effect(final software.amazon.awscdk.services.iam.Effect effect) {
            this.props().effect(effect);
            return this;
        }

        /**
         * List of not actions to add to the statement.
         * <p>
         * Default: - no not-actions
         * <p>
         * @return {@code this}
         * @param notActions List of not actions to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notActions(final java.util.List<java.lang.String> notActions) {
            this.props().notActions(notActions);
            return this;
        }

        /**
         * List of not principals to add to the statement.
         * <p>
         * Default: - no not principals
         * <p>
         * @return {@code this}
         * @param notPrincipals List of not principals to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notPrincipals(final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> notPrincipals) {
            this.props().notPrincipals(notPrincipals);
            return this;
        }

        /**
         * NotResource ARNs to add to the statement.
         * <p>
         * Default: - no not-resources
         * <p>
         * @return {@code this}
         * @param notResources NotResource ARNs to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notResources(final java.util.List<java.lang.String> notResources) {
            this.props().notResources(notResources);
            return this;
        }

        /**
         * List of principals to add to the statement.
         * <p>
         * Default: - no principals
         * <p>
         * @return {@code this}
         * @param principals List of principals to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principals(final java.util.List<software.amazon.awscdk.services.iam.IPrincipal> principals) {
            this.props().principals(principals);
            return this;
        }

        /**
         * Resource ARNs to add to the statement.
         * <p>
         * Default: - no resources
         * <p>
         * @return {@code this}
         * @param resources Resource ARNs to add to the statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<java.lang.String> resources) {
            this.props().resources(resources);
            return this;
        }

        /**
         * The Sid (statement ID) is an optional identifier that you provide for the policy statement.
         * <p>
         * You can assign a Sid value to each statement in a
         * statement array. In services that let you specify an ID element, such as
         * SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
         * IAM, the Sid value must be unique within a JSON policy.
         * <p>
         * Default: - no sid
         * <p>
         * @return {@code this}
         * @param sid The Sid (statement ID) is an optional identifier that you provide for the policy statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sid(final java.lang.String sid) {
            this.props().sid(sid);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iam.PolicyStatement}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.PolicyStatement build() {
            return new software.amazon.awscdk.services.iam.PolicyStatement(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyStatementProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyStatementProps.Builder();
            }
            return this.props;
        }
    }
}
