package software.amazon.awscdk.services.iam;

/**
 * A collection of the fields in a PolicyStatement that can be used to identify a principal.
 * <p>
 * This consists of the JSON used in the "Principal" field, and optionally a
 * set of "Condition"s that need to be applied to the policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-28T21:12:16.105Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.PrincipalPolicyFragment")
public class PrincipalPolicyFragment extends software.amazon.jsii.JsiiObject {

    protected PrincipalPolicyFragment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PrincipalPolicyFragment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param principalJson JSON of the "Principal" section in a policy statement. This parameter is required.
     * @param conditions The conditions under which the policy is in effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PrincipalPolicyFragment(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> principalJson, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(principalJson, "principalJson is required"), conditions });
    }

    /**
     * @param principalJson JSON of the "Principal" section in a policy statement. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PrincipalPolicyFragment(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> principalJson) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(principalJson, "principalJson is required") });
    }

    /**
     * The conditions under which the policy is in effect.
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">the IAM documentation</a>.
     * conditions that need to be applied to this policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * JSON of the "Principal" section in a policy statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> getPrincipalJson() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("principalJson", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)))));
    }
}
