package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation to both identity and resource.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:21:33.204Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GrantOnPrincipalAndResourceOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.CommonGrantOptions {
    /**
     * The resource with a resource policy.
     * 
     * The statement will always be added to the resource policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IResourceWithPolicy getResource();

    /**
     * When referring to the resource in a resource policy, use this as ARN.
     * 
     * (Depending on the resource type, this needs to be '*' in a resource policy).
     * 
     * Default: Same as regular resource ARNs
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getResourceSelfArns();

    /**
     * @return a {@link Builder} of {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        private java.util.List<java.lang.String> resourceSelfArns;
        private java.util.List<java.lang.String> actions;
        private software.amazon.awscdk.services.iam.IGrantable grantee;
        private java.util.List<java.lang.String> resourceArns;

        /**
         * Sets the value of Resource
         * @param resource The resource with a resource policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resource(software.amazon.awscdk.services.iam.IResourceWithPolicy resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of ResourceSelfArns
         * @param resourceSelfArns When referring to the resource in a resource policy, use this as ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceSelfArns(java.util.List<java.lang.String> resourceSelfArns) {
            this.resourceSelfArns = resourceSelfArns;
            return this;
        }

        /**
         * Sets the value of Actions
         * @param actions The actions to grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of Grantee
         * @param grantee The principal to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder grantee(software.amazon.awscdk.services.iam.IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of ResourceArns
         * @param resourceArns The resource ARNs to grant to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantOnPrincipalAndResourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public GrantOnPrincipalAndResourceOptions build() {
            return new Jsii$Proxy(resource, resourceSelfArns, actions, grantee, resourceArns);
        }

    }

    /**
     * An implementation for {@link GrantOnPrincipalAndResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantOnPrincipalAndResourceOptions {
        private final software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        private final java.util.List<java.lang.String> resourceSelfArns;
        private final java.util.List<java.lang.String> actions;
        private final software.amazon.awscdk.services.iam.IGrantable grantee;
        private final java.util.List<java.lang.String> resourceArns;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.resource = this.jsiiGet("resource", software.amazon.awscdk.services.iam.IResourceWithPolicy.class);
            this.resourceSelfArns = this.jsiiGet("resourceSelfArns", java.util.List.class);
            this.actions = this.jsiiGet("actions", java.util.List.class);
            this.grantee = this.jsiiGet("grantee", software.amazon.awscdk.services.iam.IGrantable.class);
            this.resourceArns = this.jsiiGet("resourceArns", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.iam.IResourceWithPolicy resource, java.util.List<java.lang.String> resourceSelfArns, java.util.List<java.lang.String> actions, software.amazon.awscdk.services.iam.IGrantable grantee, java.util.List<java.lang.String> resourceArns) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resource = java.util.Objects.requireNonNull(resource, "resource is required");
            this.resourceSelfArns = resourceSelfArns;
            this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
            this.grantee = java.util.Objects.requireNonNull(grantee, "grantee is required");
            this.resourceArns = java.util.Objects.requireNonNull(resourceArns, "resourceArns is required");
        }

        @Override
        public software.amazon.awscdk.services.iam.IResourceWithPolicy getResource() {
            return this.resource;
        }

        @Override
        public java.util.List<java.lang.String> getResourceSelfArns() {
            return this.resourceSelfArns;
        }

        @Override
        public java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.grantee;
        }

        @Override
        public java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("resource", om.valueToTree(this.getResource()));
            if (this.getResourceSelfArns() != null) {
                obj.set("resourceSelfArns", om.valueToTree(this.getResourceSelfArns()));
            }
            obj.set("actions", om.valueToTree(this.getActions()));
            obj.set("grantee", om.valueToTree(this.getGrantee()));
            obj.set("resourceArns", om.valueToTree(this.getResourceArns()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantOnPrincipalAndResourceOptions.Jsii$Proxy that = (GrantOnPrincipalAndResourceOptions.Jsii$Proxy) o;

            if (!resource.equals(that.resource)) return false;
            if (this.resourceSelfArns != null ? !this.resourceSelfArns.equals(that.resourceSelfArns) : that.resourceSelfArns != null) return false;
            if (!actions.equals(that.actions)) return false;
            if (!grantee.equals(that.grantee)) return false;
            return this.resourceArns.equals(that.resourceArns);
        }

        @Override
        public int hashCode() {
            int result = this.resource.hashCode();
            result = 31 * result + (this.resourceSelfArns != null ? this.resourceSelfArns.hashCode() : 0);
            result = 31 * result + (this.actions.hashCode());
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.resourceArns.hashCode());
            return result;
        }

    }
}
