package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:21:33.206Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A name for the IAM group.
     * 
     * For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * 
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * 
     * Default: Generated by CloudFormation (recommended)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getGroupName();

    /**
     * A list of managed policies associated with this role.
     * 
     * You can add managed policies later using
     * `addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))`.
     * 
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies();

    /**
     * The path to the group.
     * 
     * For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     * 
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();

    /**
     * @return a {@link Builder} of {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String groupName;
        private java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private java.lang.String path;

        /**
         * Sets the value of GroupName
         * @param groupName A name for the IAM group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of ManagedPolicies
         * @param managedPolicies A list of managed policies associated with this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.managedPolicies = managedPolicies;
            return this;
        }

        /**
         * Sets the value of Path
         * @param path The path to the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public GroupProps build() {
            return new Jsii$Proxy(groupName, managedPolicies, path);
        }

    }

    /**
     * An implementation for {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupProps {
        private final java.lang.String groupName;
        private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private final java.lang.String path;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.groupName = this.jsiiGet("groupName", java.lang.String.class);
            this.managedPolicies = this.jsiiGet("managedPolicies", java.util.List.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String groupName, java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies, java.lang.String path) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupName = groupName;
            this.managedPolicies = managedPolicies;
            this.path = path;
        }

        @Override
        public java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.managedPolicies;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getGroupName() != null) {
                obj.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getManagedPolicies() != null) {
                obj.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
            }
            if (this.getPath() != null) {
                obj.set("path", om.valueToTree(this.getPath()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GroupProps.Jsii$Proxy that = (GroupProps.Jsii$Proxy) o;

            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.managedPolicies != null ? !this.managedPolicies.equals(that.managedPolicies) : that.managedPolicies != null) return false;
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        @Override
        public int hashCode() {
            int result = this.groupName != null ? this.groupName.hashCode() : 0;
            result = 31 * result + (this.managedPolicies != null ? this.managedPolicies.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

    }
}
