package software.amazon.awscdk.services.iam;

/**
 * Options for a service principal.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:21:33.223Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServicePrincipalOpts extends software.amazon.jsii.JsiiSerializable {
    /**
     * Additional conditions to add to the Service Principal.
     * 
     * Default: - No conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Object> getConditions();

    /**
     * The region in which the service is operating.
     * 
     * Default: the current Stack's region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getRegion();

    /**
     * @return a {@link Builder} of {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.Map<java.lang.String, java.lang.Object> conditions;
        private java.lang.String region;

        /**
         * Sets the value of Conditions
         * @param conditions Additional conditions to add to the Service Principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.Map<java.lang.String, java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of Region
         * @param region The region in which the service is operating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServicePrincipalOpts}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ServicePrincipalOpts build() {
            return new Jsii$Proxy(conditions, region);
        }

    }

    /**
     * An implementation for {@link ServicePrincipalOpts}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServicePrincipalOpts {
        private final java.util.Map<java.lang.String, java.lang.Object> conditions;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.conditions = this.jsiiGet("conditions", java.util.Map.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.Map<java.lang.String, java.lang.Object> conditions, java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.conditions = conditions;
            this.region = region;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getConditions() {
            return this.conditions;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getConditions() != null) {
                obj.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getRegion() != null) {
                obj.set("region", om.valueToTree(this.getRegion()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServicePrincipalOpts.Jsii$Proxy that = (ServicePrincipalOpts.Jsii$Proxy) o;

            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.conditions != null ? this.conditions.hashCode() : 0;
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }

    }
}
