package software.amazon.awscdk.services.iam;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.2 (build dfe9aaf)", date = "2019-08-29T13:38:45.338Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedPolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * A description of the managed policy.
     * 
     * Typically used to store information about the
     * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     * 
     * Default: - empty
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
     * 
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups();

    /**
     * The name of the managed policy.
     * 
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * 
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getManagedPolicyName();

    /**
     * The path for the policy.
     * 
     * This parameter allows (through its regex pattern) a string of characters
     * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
     * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
     * including most punctuation characters, digits, and upper and lowercased letters.
     * 
     * For more information about paths, see IAM Identifiers in the IAM User Guide.
     * 
     * Default: - "/"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();

    /**
     * Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
     * 
     * Default: - No roles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles();

    /**
     * Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
     * 
     * Default: - No statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements();

    /**
     * Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
     * 
     * Default: - No users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers();

    /**
     * @return a {@link Builder} of {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String description;
        private java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private java.lang.String managedPolicyName;
        private java.lang.String path;
        private java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Sets the value of Description
         * @param description A description of the managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Groups
         * @param groups Groups to attach this policy to. You can also use `attachToGroup(group)` to attach this policy to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(java.util.List<software.amazon.awscdk.services.iam.IGroup> groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of ManagedPolicyName
         * @param managedPolicyName The name of the managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(java.lang.String managedPolicyName) {
            this.managedPolicyName = managedPolicyName;
            return this;
        }

        /**
         * Sets the value of Path
         * @param path The path for the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of Roles
         * @param roles Roles to attach this policy to. You can also use `attachToRole(role)` to attach this policy to a role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.util.List<software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Sets the value of Statements
         * @param statements Initial set of permissions to add to this policy document. You can also use `addPermission(statement)` to add permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.statements = statements;
            return this;
        }

        /**
         * Sets the value of Users
         * @param users Users to attach this policy to. You can also use `attachToUser(user)` to attach this policy to a user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            this.users = users;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ManagedPolicyProps build() {
            return new Jsii$Proxy(description, groups, managedPolicyName, path, roles, statements, users);
        }

    }

    /**
     * An implementation for {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedPolicyProps {
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private final java.lang.String managedPolicyName;
        private final java.lang.String path;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private final java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.groups = this.jsiiGet("groups", java.util.List.class);
            this.managedPolicyName = this.jsiiGet("managedPolicyName", java.lang.String.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
            this.roles = this.jsiiGet("roles", java.util.List.class);
            this.statements = this.jsiiGet("statements", java.util.List.class);
            this.users = this.jsiiGet("users", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String description, java.util.List<software.amazon.awscdk.services.iam.IGroup> groups, java.lang.String managedPolicyName, java.lang.String path, java.util.List<software.amazon.awscdk.services.iam.IRole> roles, java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements, java.util.List<software.amazon.awscdk.services.iam.IUser> users) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = description;
            this.groups = groups;
            this.managedPolicyName = managedPolicyName;
            this.path = path;
            this.roles = roles;
            this.statements = statements;
            this.users = users;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.groups;
        }

        @Override
        public java.lang.String getManagedPolicyName() {
            return this.managedPolicyName;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.statements;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.users;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroups() != null) {
                obj.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getManagedPolicyName() != null) {
                obj.set("managedPolicyName", om.valueToTree(this.getManagedPolicyName()));
            }
            if (this.getPath() != null) {
                obj.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getRoles() != null) {
                obj.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getStatements() != null) {
                obj.set("statements", om.valueToTree(this.getStatements()));
            }
            if (this.getUsers() != null) {
                obj.set("users", om.valueToTree(this.getUsers()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedPolicyProps.Jsii$Proxy that = (ManagedPolicyProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.managedPolicyName != null ? !this.managedPolicyName.equals(that.managedPolicyName) : that.managedPolicyName != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.statements != null ? !this.statements.equals(that.statements) : that.statements != null) return false;
            return this.users != null ? this.users.equals(that.users) : that.users == null;
        }

        @Override
        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
            result = 31 * result + (this.managedPolicyName != null ? this.managedPolicyName.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
            result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
            return result;
        }

    }
}
