/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatementProps;
import software.amazon.jsii.JsiiSerializable;

public interface PolicyStatementProps
extends JsiiSerializable {
    public List<String> getActions();

    public Map<String, Object> getConditions();

    public Effect getEffect();

    public List<String> getNotActions();

    public List<String> getNotResources();

    public List<IPrincipal> getPrincipals();

    public List<String> getResources();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> actions;
        private Map<String, Object> conditions;
        private Effect effect;
        private List<String> notActions;
        private List<String> notResources;
        private List<IPrincipal> principals;
        private List<String> resources;

        public Builder actions(List<String> actions) {
            this.actions = actions;
            return this;
        }

        public Builder conditions(Map<String, Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder effect(Effect effect) {
            this.effect = effect;
            return this;
        }

        public Builder notActions(List<String> notActions) {
            this.notActions = notActions;
            return this;
        }

        public Builder notResources(List<String> notResources) {
            this.notResources = notResources;
            return this;
        }

        public Builder principals(List<IPrincipal> principals) {
            this.principals = principals;
            return this;
        }

        public Builder resources(List<String> resources) {
            this.resources = resources;
            return this;
        }

        public PolicyStatementProps build() {
            return new Jsii.Proxy(this.actions, this.conditions, this.effect, this.notActions, this.notResources, this.principals, this.resources, null);
        }
    }
}

