/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.iam.;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatementProps;
import software.amazon.awscdk.services.iam.ServicePrincipalOpts;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-iam.PolicyStatement")
public class PolicyStatement
extends JsiiObject {
    protected PolicyStatement(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PolicyStatement(@Nullable PolicyStatementProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PolicyStatement() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static PolicyStatement fromJson(@NotNull Object obj) {
        return (PolicyStatement)((Object)JsiiObject.jsiiStaticCall(PolicyStatement.class, (String)"fromJson", PolicyStatement.class, (Object[])new Object[]{obj}));
    }

    public void addAccountCondition(@NotNull String accountId) {
        this.jsiiCall("addAccountCondition", NativeType.VOID, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addAccountRootPrincipal() {
        this.jsiiCall("addAccountRootPrincipal", NativeType.VOID, new Object[0]);
    }

    public void addActions(String ... actions) {
        this.jsiiCall("addActions", NativeType.VOID, Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addAllResources() {
        this.jsiiCall("addAllResources", NativeType.VOID, new Object[0]);
    }

    public void addAnyPrincipal() {
        this.jsiiCall("addAnyPrincipal", NativeType.VOID, new Object[0]);
    }

    public void addArnPrincipal(@NotNull String arn) {
        this.jsiiCall("addArnPrincipal", NativeType.VOID, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    public void addAwsAccountPrincipal(@NotNull String accountId) {
        this.jsiiCall("addAwsAccountPrincipal", NativeType.VOID, new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addCanonicalUserPrincipal(@NotNull String canonicalUserId) {
        this.jsiiCall("addCanonicalUserPrincipal", NativeType.VOID, new Object[]{Objects.requireNonNull(canonicalUserId, "canonicalUserId is required")});
    }

    public void addCondition(@NotNull String key, @NotNull Object value) {
        this.jsiiCall("addCondition", NativeType.VOID, new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addConditions(@NotNull Map<String, Object> conditions) {
        this.jsiiCall("addConditions", NativeType.VOID, new Object[]{Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addFederatedPrincipal(@NotNull Object federated, @NotNull Map<String, Object> conditions) {
        this.jsiiCall("addFederatedPrincipal", NativeType.VOID, new Object[]{federated, Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addNotActions(String ... notActions) {
        this.jsiiCall("addNotActions", NativeType.VOID, Arrays.stream(notActions).toArray(Object[]::new));
    }

    public void addNotPrincipals(IPrincipal ... notPrincipals) {
        this.jsiiCall("addNotPrincipals", NativeType.VOID, Arrays.stream(notPrincipals).toArray(Object[]::new));
    }

    public void addNotResources(String ... arns) {
        this.jsiiCall("addNotResources", NativeType.VOID, Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addPrincipals(IPrincipal ... principals) {
        this.jsiiCall("addPrincipals", NativeType.VOID, Arrays.stream(principals).toArray(Object[]::new));
    }

    public void addResources(String ... arns) {
        this.jsiiCall("addResources", NativeType.VOID, Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addServicePrincipal(@NotNull String service, @Nullable ServicePrincipalOpts opts) {
        this.jsiiCall("addServicePrincipal", NativeType.VOID, new Object[]{Objects.requireNonNull(service, "service is required"), opts});
    }

    public void addServicePrincipal(@NotNull String service) {
        this.jsiiCall("addServicePrincipal", NativeType.VOID, new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @NotNull
    public Object toJSON() {
        return this.jsiiCall("toJSON", Object.class, new Object[0]);
    }

    @NotNull
    public Object toStatementJson() {
        return this.jsiiCall("toStatementJson", Object.class, new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)this.jsiiCall("toString", String.class, new Object[0]);
    }

    @NotNull
    public List<String> validateForAnyPolicy() {
        return Collections.unmodifiableList((List)this.jsiiCall("validateForAnyPolicy", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public List<String> validateForIdentityPolicy() {
        return Collections.unmodifiableList((List)this.jsiiCall("validateForIdentityPolicy", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public List<String> validateForResourcePolicy() {
        return Collections.unmodifiableList((List)this.jsiiCall("validateForResourcePolicy", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public Boolean getHasPrincipal() {
        return (Boolean)this.jsiiGet("hasPrincipal", Boolean.class);
    }

    @NotNull
    public Boolean getHasResource() {
        return (Boolean)this.jsiiGet("hasResource", Boolean.class);
    }

    @NotNull
    public Effect getEffect() {
        return (Effect)((Object)this.jsiiGet("effect", Effect.class));
    }

    public void setEffect(@NotNull Effect value) {
        this.jsiiSet("effect", (Object)Objects.requireNonNull(value, "effect is required"));
    }

    @Nullable
    public String getSid() {
        return (String)this.jsiiGet("sid", String.class);
    }

    public void setSid(@Nullable String value) {
        this.jsiiSet("sid", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PolicyStatement> {
        private PolicyStatementProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder actions(List<String> actions) {
            this.props().actions(actions);
            return this;
        }

        public Builder conditions(Map<String, Object> conditions) {
            this.props().conditions(conditions);
            return this;
        }

        public Builder effect(Effect effect) {
            this.props().effect(effect);
            return this;
        }

        public Builder notActions(List<String> notActions) {
            this.props().notActions(notActions);
            return this;
        }

        public Builder notPrincipals(List<IPrincipal> notPrincipals) {
            this.props().notPrincipals(notPrincipals);
            return this;
        }

        public Builder notResources(List<String> notResources) {
            this.props().notResources(notResources);
            return this;
        }

        public Builder principals(List<IPrincipal> principals) {
            this.props().principals(principals);
            return this;
        }

        public Builder resources(List<String> resources) {
            this.props().resources(resources);
            return this;
        }

        public Builder sid(String sid) {
            this.props().sid(sid);
            return this;
        }

        public PolicyStatement build() {
            return new PolicyStatement(this.props != null ? this.props.build() : null);
        }

        private PolicyStatementProps.Builder props() {
            if (this.props == null) {
                this.props = new PolicyStatementProps.Builder();
            }
            return this.props;
        }
    }
}

